#ifndef __raw_tests_h__
#define __raw_tests_h__

#include "test.h"

template<class TData>
struct accumulate_test : public test_t<TData>
{
    accumulate_test() : test_t<TData>("Accumulator test") {}
    accumulate_test(const char* desc) : test_t<TData>(desc) {}

    virtual void test(TData& data) { data++; }
};

template<class TData>
struct raw_bit_mask_test_set_all : public test_t<TData>
{
    raw_bit_mask_test_set_all() : test_t<TData>("raw bitmask test - set all") {}
    raw_bit_mask_test_set_all(const char* desc) : test_t<TData>(desc) {}

    virtual void test(TData& data) { 
        data |= (~TData(0));
    }
};

template<class TData>
struct raw_bit_mask_test_clear_all : public test_t<TData>
{
    raw_bit_mask_test_clear_all() : test_t<TData>("raw bitmask test - clear all") {}
    raw_bit_mask_test_clear_all(const char* desc) : test_t<TData>(desc) {}

    virtual void test(TData& data) { 
        data &= TData(0);
    }
};

template<class TData>
struct raw_bit_mask_test_toggle_all : public test_t<TData>
{
    raw_bit_mask_test_toggle_all() : test_t<TData>("raw bitmask test - clear all") {}
    raw_bit_mask_test_toggle_all(const char* desc) : test_t<TData>(desc) {}

    virtual void test(TData& data) { 
        data ^=  (~TData(0));
    }
};

template<class TData>
struct raw_bit_mask_test_right_shift_1 : public test_t<TData>
{
    raw_bit_mask_test_right_shift_1() : test_t<TData>("raw bitmask test - right shift 1") {}
    raw_bit_mask_test_right_shift_1(const char* desc) : test_t<TData>(desc) {}

    virtual void test(TData& data) { 
        data >>=1;
    }
};

template<class TData>
struct raw_bit_mask_test_left_shift_1 : public test_t<TData>
{
    raw_bit_mask_test_left_shift_1() : test_t<TData>("raw bitmask test - left shift 1") {}
    raw_bit_mask_test_left_shift_1(const char* desc) : test_t<TData>(desc) {}

    virtual void test(TData& data) { 
        data <<=1;
    }
};

void execute_raw_tests();

#endif//#ifndef __raw_tests_h__