#include "mbed.h"
#include "misc.h"
#include "bit_storage.h"
#include "test.h"
#include "bit_storage_tests.h"

extern Timer timer;

void execute_bit_storage_timed_tests();
void bit_storage_effects_tests();

void execute_bit_storage_tests() {
    //bit_storage_effects_tests();
    execute_bit_storage_timed_tests();
}

bit_storage_t<64,uint32_t,true> bits_t;
bit_storage_t<64,uint32_t,false> bits_f;

void bit_storage_effects_tests()
{
    pc.printf("set all:\r\n"),bits_t.set_all(),describe(bits_t);
    pc.printf("clear all:\r\n"),bits_t.clear_all(),describe(bits_t);
    pc.printf("toggle all:\r\n"),bits_t.toggle_all(),describe(bits_t);
    pc.printf("shift_left 5:\r\n"),bits_t.shift_left(5),describe(bits_t);
    bits_t.set_all();
    pc.printf("right 5:\r\n"),bits_t.shift_right(5),describe(bits_t);

    pc.printf("set all:\r\n"),bits_f.set_all(),describe(bits_f);
    pc.printf("clear all:\r\n"),bits_f.clear_all(),describe(bits_f);
    pc.printf("toggle all:\r\n"),bits_f.toggle_all(),describe(bits_f);
    pc.printf("shift_left 5:\r\n"),bits_f.shift_left(5),describe(bits_f);
    bits_f.set_all();
    pc.printf("right 5:\r\n"),bits_f.shift_right(5),describe(bits_f);
}

template<
    size_t bit_size, 
    class storage_type,
    bool msb_zero>
int time_bit_storage_set_all(int repeat=1000000) {
    //typedef  test_type;
    bit_storage_test_set_all<bit_size,storage_type,msb_zero> test;
    bit_storage_t<bit_size,storage_type,msb_zero> data;
    return time_test_execution(timer,test,data,repeat);
}

template<
    size_t bit_size, 
    class storage_type,
    bool msb_zero>
int time_bit_storage_clear_all(int repeat=1000000) {
    //typedef  test_type;
    bit_storage_test_clear_all<bit_size,storage_type,msb_zero> test;
    bit_storage_t<bit_size,storage_type,msb_zero> data;
    return time_test_execution(timer,test,data,repeat);
}

template<
    size_t bit_size, 
    class storage_type,
    bool msb_zero>
int time_bit_storage_toggle_all(int repeat=1000000) {
    //typedef  test_type;
    bit_storage_test_toggle_all<bit_size,storage_type,msb_zero> test;
    bit_storage_t<bit_size,storage_type,msb_zero> data;
    return time_test_execution(timer,test,data,repeat);
}


template<
    size_t bit_size, 
    class storage_type,
    bool msb_zero>
int time_bit_storage_left_shift_1(int repeat=1000000) {
    //typedef  test_type;
    bit_storage_test_left_shift_1<bit_size,storage_type,msb_zero> test;
    bit_storage_t<bit_size,storage_type,msb_zero> data;
    return time_test_execution(timer,test,data,repeat);
}

template<
    size_t bit_size, 
    class storage_type,
    bool msb_zero>
int time_bit_storage_right_shift_1(int repeat=1000000) {
    //typedef  test_type;
    bit_storage_test_right_shift_1<bit_size,storage_type,msb_zero> test;
    bit_storage_t<bit_size,storage_type,msb_zero> data;
    return time_test_execution(timer,test,data,repeat);
}

template<
    size_t bit_size, 
    class storage_type,
    bool msb_zero>
int time_bit_storage_left_shift_1_third(int repeat=1000000) {
    //typedef  test_type;
    bit_storage_test_left_shift_1_third<bit_size,storage_type,msb_zero> test;
    bit_storage_t<bit_size,storage_type,msb_zero> data;
    return time_test_execution(timer,test,data,repeat);
}

template<
    size_t bit_size, 
    class storage_type,
    bool msb_zero>
int time_bit_storage_right_shift_1_third(int repeat=1000000) {
    //typedef  test_type;
    bit_storage_test_right_shift_1_third<bit_size,storage_type,msb_zero> test;
    bit_storage_t<bit_size,storage_type,msb_zero> data;
    return time_test_execution(timer,test,data,repeat);
}


template<
    size_t bit_size, 
    class storage_type,
    bool msb_zero>
void execute_sized_bit_storage_timed_tests()
{
  char desc[50];
  sprintf(desc,"bit_storage_t<%d,uint%d_t,%s>",bit_size,sizeof(storage_type)*8,msb_zero?"true":"false");
  pc.printf("%s set_all - %d ms\r\n",desc,
    time_bit_storage_set_all<bit_size,storage_type,msb_zero>());

  pc.printf("%s clear_all - %d ms\r\n",desc,
    time_bit_storage_clear_all<bit_size,storage_type,msb_zero>());
    
  pc.printf("%s toggle_all - %d ms\r\n",desc,
    time_bit_storage_toggle_all<bit_size,storage_type,msb_zero>());
    
  pc.printf("%s right_shift 1 - %d ms\r\n",desc,
    time_bit_storage_right_shift_1<bit_size,storage_type,msb_zero>());

  pc.printf("%s left_shift 1 - %d ms\r\n",desc,
    time_bit_storage_left_shift_1<bit_size,storage_type,msb_zero>());

  pc.printf("%s right_shift 1/3 - %d ms\r\n",desc,
    time_bit_storage_right_shift_1_third<bit_size,storage_type,msb_zero>());

  pc.printf("%s left_shift 1/3 - %d ms\r\n",desc,
    time_bit_storage_left_shift_1_third<bit_size,storage_type,msb_zero>());

}

template<size_t bits,class storage_type>
void execute_sized_bit_storage_timed_tests()
{
    execute_sized_bit_storage_timed_tests<bits,storage_type,true>();
    execute_sized_bit_storage_timed_tests<bits,storage_type,false>();    
}

template<class storage_type>
void execute_sized_bit_storage_timed_tests()
{
    execute_sized_bit_storage_timed_tests<8,storage_type>();
    execute_sized_bit_storage_timed_tests<16,storage_type>();
    execute_sized_bit_storage_timed_tests<32,storage_type>();
    execute_sized_bit_storage_timed_tests<64,storage_type>();
}

void execute_bit_storage_timed_tests()
{
  pc.printf("execute_bit_storage_timed_tests:\r\n\r\n");

//  execute_sized_bit_storage_timed_tests<uint8_t>();
//  execute_sized_bit_storage_timed_tests<uint16_t>();
  //execute_sized_bit_storage_timed_tests<uint32_t>();
//  execute_sized_bit_storage_timed_tests<uint64_t>();
//  execute_sized_bit_storage_timed_tests<512,uint8_t,true>();
//  execute_sized_bit_storage_timed_tests<512,uint16_t,true>();
  execute_sized_bit_storage_timed_tests<512,uint32_t>();
//  execute_sized_bit_storage_timed_tests<512,uint64_t,true>();
  
//  execute_sized_bit_storage_timed_tests<512,uint8_t,false>();
//  execute_sized_bit_storage_timed_tests<512,uint16_t,false>();
 // execute_sized_bit_storage_timed_tests<512,uint32_t,false>();
//  execute_sized_bit_storage_timed_tests<512,uint64_t,false>();
}