#include "globals.h"

class Fishing
{
    public:
        Fishing();
        void start();
        void lake_init();
        void grass(int x, int y, int n, int color);
        void draw_fish(int x, int dist);
        void draw_rod(int n, int x);
    
    private:
        int oldx;
        int oldx2;
        int oldCnt;
};

Fishing::Fishing() {
    oldx = 0;
    oldx2 = 64;
    oldCnt = 1;
}

void Fishing::start() {                 //Title Screen
    stdio_mutex.lock();
    uLCD.text_width(1);
    uLCD.text_height(1);
    uLCD.printf("Fishing Simulator V1.0");
    wait(2.0);
    stdio_mutex.unlock();
}

void Fishing::lake_init() {             //Initial lake or pond
    stdio_mutex.lock();
    uLCD.filled_rectangle(0, 0 , 127, 127, BLACK);
    for(int i =0; i < 17; i++) {
        uLCD.line(0, 23+i, 127, 23+i, i*0x000F);
    }
    uLCD.filled_rectangle(0, 40, 127, 127, BLUE);
    uLCD.line(88, 40, 108, 108, RED);
    uLCD.line(20, 108, 40, 40, RED);
    stdio_mutex.unlock();
}

void Fishing::grass(int x, int y, int n, int color) {           //Drawing of the grass
        uLCD.circle(x+2*n-2, y+4*n , n, 0x000042);
        uLCD.circle(x+2*n+1, y+4*n , n, 0x000042);
        uLCD.circle(x+2*n-2, y+4*n , n-1, 0x444444);
        uLCD.circle(x+2*n+1, y+4*n , n-1, 0x444444);
        uLCD.filled_circle(x+2*n-2, y+4*n , n-2, 0x000042);
        uLCD.filled_circle(x+2*n+1, y+4*n , n-2, 0x000042);
        uLCD.filled_circle(x+2*n-1, y+4*n , n-2, 0x000042);
    for (int i = n; i < 2*n; i++) {
        uLCD.line(x, y+2*n, x+i, y + 4*n, color - (0x000500 * i));
    }
    for (int j = 2*n; j < 3*n; j++) {
        uLCD.line(x, y+2*n, x+j, y + 4*n, color - (0x000500 * j));
        uLCD.line(x+n, y, x+j, y + 4*n, color - (0x000500 * j));
        uLCD.line(x+4*n, y+n, x+j, y + 4*n, color - (0x000500 * j));
    }
}

void Fishing::draw_fish(int x, int dist) {              //Drawing of the fish
    stdio_mutex.lock();
    if(oldx != x) {
        uLCD.filled_circle(oldx, 80 , 4, BLUE);
        oldx = x;
        uLCD.circle(x-1, 80 , 3, 0x000042);
        uLCD.circle(x+1, 80 , 3, 0x000042);
        uLCD.circle(x-1, 80 , 2, 0x444444);
        uLCD.circle(x+1, 80 , 2, 0x444444);
        uLCD.filled_circle(x, 80 , 1, 0x000042);
        uLCD.filled_circle(x+1, 80 , 1, 0x000042);
    }
    uLCD.locate(7,15);
    uLCD.printf("%d", dist);
    stdio_mutex.unlock();
}

void Fishing::draw_rod(int n, int x) {                  //Drawing of the fishing rod
    if (oldCnt != n || oldx2 != x) {
        stdio_mutex.lock();
        uLCD.line(64 + 6*oldCnt,95, 64 + 7*oldCnt, 100, BLUE);
        uLCD.line(64 + 7*oldCnt,99, 64 + 8*oldCnt, 106, BLUE);
        uLCD.line(64 + 8*oldCnt,106, 64 + 7*oldCnt, 115, BLUE);
        uLCD.line(64 + 7*oldCnt,115, 64, 127, BLUE);
        uLCD.line(oldx2, 80, 64 + 6*oldCnt, 95, BLUE);
        oldCnt = n;
        oldx2 = x;
        uLCD.line(64 + 6*n,95, 64 + 7*n, 100, 0x964B00);
        uLCD.line(64 + 7*n,99, 64 + 8*n, 106, 0x964B00);
        uLCD.line(64 + 8*n,106, 64 + 7*n, 115, 0x964B00);
        uLCD.line(64 + 7*n,115, 64, 127, 0x964B00);
        uLCD.line(x, 80, 64 + 6*n, 95, WHITE);
        stdio_mutex.unlock();
    }
}