#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "Nav_Switch.h"
#include "Fish.h"
#include "Fishing.h"
#include "SDFileSystem.h"
#include "wave_player.h"

uLCD_4DGL uLCD(p28,p27,p29);                 //LCD screen
Nav_Switch myNav( p9, p6, p7, p5, p8);      //Navigation Switch

SDFileSystem sd(p11, p12, p13, p10, "sd");      //SD Card Reader
AnalogOut DACout(p18);                      //Wave Player Output
wave_player waver(&DACout);

Mutex stdio_mutex;                          //Mutex for Threads

BusOut mbedleds(LED1,LED2,LED3,LED4);       //BusOut for all LEDs at once

Fishing fisher;

int dist;
int rem1;
int rem2;
int old1;
int old2;

bool fishing = false;
bool lure = false;
bool success = false;

void lakeside_thread(void const *args) {        //This is a thread that displays moving pieces of grass to mimic movement.
    while(1) {
        stdio_mutex.lock();
        rem1 = dist%20;
        rem2 = (dist+10)%20;
        if (old1 != rem1 && rem1 != 0) {
            uLCD.filled_rectangle(40-3*old1, 10+(old1*6), 40-3*old1+ 4*((old1/5)+1), 10+(old1*6) + 5*((old1/5)+2), BLUE);
            uLCD.filled_rectangle(20, 0, 48, 23, BLACK);
            uLCD.line(20, 108, 40, 40, RED);
            if (old1 < 23) {
                for(int i =0; i < 17; i++) {
                    uLCD.line(20, 23+i, 50, 23+i, i*0x000F);
                }
            }
            old1 = rem1;
            fisher.grass(40-3*rem1, 10+(rem1*6), (rem1/5)+1, GREEN);
        }
        if (old2 != rem2 && rem2 != 0) {
            uLCD.filled_rectangle(88+2*old2, 10+(old2*6), 88+2*old2 + 4*((old2/5)+1), 10+(old2*6) + 5*((old2/5)+2), BLUE);
            uLCD.filled_rectangle(88, 0 , 108, 23, BLACK);
            uLCD.line(88, 40, 108, 108, RED);
            if (old2 < 23) {
                for(int i =0; i < 17; i++) {
                    uLCD.line(78, 23+i, 108, 23+i, i*0x000F);
                }
            }   
            old2 = rem2;
            fisher.grass(88+2*rem2, 10+(rem2*6), (rem2/5)+1, GREEN);
        }
        stdio_mutex.unlock();
    }
}

void bgm_thread(void const *args) {
    FILE *wave_file;
    while(true) {
        while(lure) {
            wave_file=fopen("/sd/wavfiles/Water Drop.wav","r");         //Sound for casting a lure
            waver.play(wave_file);
            fclose(wave_file);
            Thread::wait(5000);
        }
        while(fishing) {
            wave_file=fopen("/sd/wavfiles/Stream Noise.wav","r");       //Sound for reeling in the fish
            waver.play(wave_file);
            fclose(wave_file);
            Thread::wait(50);
        }
        while(success) {
            wave_file=fopen("/sd/wavfiles/Fish Splashing.wav","r");     //Sound of catching a fish
            waver.play(wave_file);
            fclose(wave_file);
            Thread::wait(1000);
        }
    }
}

int main() {
    dist = 0;
    uLCD.baudrate(3000000);                         //Increase the baudrate to improve uLCD screen
    fishing = false;                                //These bool will determine which track is playing in the sound thread.
    lure = false;
    success = false;
    
    uLCD.background_color(BLACK);
    
    fisher.start();
    wait(3);
    
    fisher.lake_init();
    
    Thread thread1(lakeside_thread);
    Thread thread2(bgm_thread);
    Fish fish1;
    int rand1 = rand() % 100;
    int cnt = 0;
    lure = true;
    
    while(1) {
        fisher.draw_fish(64, dist);
        lure = false;
        fisher.draw_rod(0, 64);
        stdio_mutex.lock();
        uLCD.locate(0,0);
        uLCD.printf("Press Center when Flashing");
        stdio_mutex.unlock();
        if(rand1 > 80) {
            for(cnt = 0; cnt < 30; cnt++) {
                mbedleds = 0x0F*(cnt%2);                        //When a fish is at the lure, the LEDs will blink
                uLCD.circle(64, 80 , 4+(cnt%8), BLACK );        //And a ripple from the shadow will appear
                uLCD.circle(64, 80 , 5+(cnt%8), BLACK );
                uLCD.circle(64, 80 , 4+(cnt%8), BLUE);
                uLCD.circle(64, 80 , 5+(cnt%8), BLUE);
                if(myNav.fire()) {                              //This gives the player 3 seconds to press the center
                    while(dist < 300) {                         //of the Navigational Switch to start reeling it in.
                        dist = dist + 5;
                    }
                    fishing = true;
                    fish1.reset();
                    cnt = 30;
                    mbedleds = 0x00;
                    stdio_mutex.lock();
                    uLCD.filled_rectangle(0,0,127,20,BLACK);
                    stdio_mutex.unlock();
                }
                wait(0.1);
            }
            cnt = 0;
        }
        while(fishing) {
            fisher.draw_fish(fish1.x(), dist);
            fish1.movement();
            dist = dist - 2;
            if (myNav.left()) {                             //Pushing left will cause the fishing rod 
                cnt--;                                      //To pull left
                if (cnt > 0) {
                    cnt-=2;
                }
            } else if (myNav.right()) {                     //Pushing right will cause the rod to pull right
                cnt++;
                if (cnt < 0) {
                    cnt+=2;
                }
            } else {
                if (cnt > 0) {
                    cnt--;
                } else if (cnt < 0) {
                    cnt++;
                }
            }
            if (cnt > 6) {
                cnt = 6;
            } else if (cnt < -6) {
                cnt = -6;
            }
            fish1.move(((64+cnt*6 - fish1.x())/30) + 1);
            fisher.draw_rod(cnt, fish1.x());
            
            if(dist == 0) {                                     //When enough time has passed, the dist reaches 0
                success = true;                                 //And it's a succesful capture of a fish
                fishing = false;
                stdio_mutex.lock();
                fisher.lake_init();
                uLCD.locate(1,1);
                uLCD.printf("You Caught It!");
                wait(3.0);
                uLCD.filled_rectangle(0,0,127,20,BLACK);
                stdio_mutex.unlock();
                success = false;
            }
            if (!(fish1.failed())) {                            //If the fish escapes too far left or right
                fishing = false;                                //The player has failed
                stdio_mutex.lock();
                fisher.lake_init();
                uLCD.locate(1,1);
                uLCD.printf("It Got Away...");
                wait(3.0);
                uLCD.filled_rectangle(0,0,127,20,BLACK);
                stdio_mutex.unlock();
            }
            wait(0.25);
        }
        rand1 = rand() % 100;
        dist = 300;
        cnt = 0;
        wait(0.1);
    }
}