class Fish
{
    public:
        Fish();
        void reset();
        int read();
        int x();
        int y();
        void move(int n);
        void movement();
        bool failed();
    private:
        int x_pos; 
        int y_pos;
        int dir;
        int size;
        int time;
        int clk;
};

Fish::Fish() {
    x_pos = 64;
    y_pos = 64;
    if (rand() % 100 > 50) {
        dir = 1;
    } else {
        dir = -1;
    }
    size = (rand() % 100) + 20;         //Size of the fish will determine how fast it can move
    time = ((rand() % 5) + 1)*5;        //Time determines how long it will either head left or right
    clk = 0;                            //Shows how much time has passed
}

void Fish::reset() {
    x_pos = 64;
    y_pos = 64;
    if (rand() % 100 > 50) {
        dir = 1;
    } else {
        dir = -1;
    }
    size = (rand() % 100) + 20;
    time = ((rand() % 5) + 1)*5;
    clk = 0;
}

int Fish::x() {
    return x_pos;
}

int Fish::y() {
    return y_pos;
}

void Fish::move(int n) {                //Changes the x-position of the fish or moves it
    x_pos = x_pos + n;
}

void Fish::movement() {                 //The movement of the fish, basically going back and forth
    if(clk >= time) {
        clk = 0;
        time = ((rand() % 5) + 1)*5;
        dir = dir * -1;
    } else {
        if (clk < (size/15)) {
            move(dir * clk);
        } else {
            move(dir * (size/15));
        }
        clk++;
    }
}

bool Fish::failed() {                   //When it reaches the outer bounds, the fish has escaped
    if(x_pos < 30 || x_pos > 98) {
        return false;
    } else {
        return true;
    }
}