/* just a test for "mbed R/C Servo Library"
 * send from PC to mbed a string like ":XXYY"<RC>
 * where XX is the hexa value [00..FF ] (0..255) of Servo1
 * and YY is the hexa value [00..FF ] (0..255) of Servo2
 * also "V"<RC> gives the version.
 */

#include "mbed.h"
#include "Servo.h"
  
PwmOut led_1(LED1);
PwmOut led_2(LED2);

Servo servo_1(p21);
Servo servo_2(p22);

Serial rs_pc(USBTX, USBRX); // virtual com (tx, rx)

// convert 2 ascii chars hex format ("00".."FF") -> 1 unsigned char (0..255)
unsigned char hex_bin (unsigned char  *ptr )
{
    unsigned char temp;

    if (*ptr>='0' && *ptr<='9') temp = *ptr & 0x0F;
                          else  temp = (*ptr & 0x0F) + 9;
    temp <<= 4;
    if (*(ptr+1)>='0' && *(ptr+1)<='9') temp |= *(ptr+1) & 0x0F;
                                  else  temp |= (*(ptr+1) & 0x0F) + 9;
    return temp;
}

int main() {
    unsigned char i=0;
    float p;
    unsigned char c;
    unsigned char cmd[6];
    while(1) {
        if(rs_pc.readable()) { // char on rs_pc
            c = rs_pc.getc();
            if (c==13){ // end of tram
                if (cmd[0]== ':'){ // cmd servos
                    rs_pc.putc(13); // ok
                    // servo 1
                    p = hex_bin(&cmd[1])/255.0; // 0.00 (min) -> 1.00 (max)
                    servo_1 = p;
                    led_1   = p; // just for eyes
                    // servo 2
                    p = hex_bin(&cmd[3])/255.0; // 0.00 (min) -> 1.00 (max)
                    servo_2 = p;
                    led_2   = p;
                }
                if (cmd[0]== 'V'){ // version
                    rs_pc.printf("Servos test V1.01.a\r");
                }
                i=0;
            }else{
                if (c==':') i=0; // start of tram
                cmd[i++]=c;
                if (i>5){
                    rs_pc.printf("Wrong command\r");
                    i=0;
                }
            }
        }
    }
}