#include "mbed.h"
#include "TextLCD.h"

#define READBUFFERSIZE (32)

Serial g_serial(USBTX, USBRX);
TextLCD g_lcd(p15, p16, p17, p18, p19, p20);  // RS, E, DB4, DB5, DB6, DB7

int ReadLineString( Serial& serial,
                    char szReadBuffer[], const int ciReadBufferSize, int& riIndexChar,
                    char szLineString[], const int ciLineStringSize )
{
    while( 1 )
    {
        if( !serial.readable() )
        {
            break;
        }
        char c = serial.getc();
        if( '\r' == c  )
        {
            szReadBuffer[riIndexChar] = '\0';
            strncpy( szLineString, szReadBuffer, ciLineStringSize - 1 );
            szLineString[ciLineStringSize - 1] = '\0';
            riIndexChar = 0;
            return 1;
        }
        else if( '\n' == c )
        {
            ;
        }
        else
        {
            if( (ciReadBufferSize - 1) > riIndexChar )
            {
                szReadBuffer[riIndexChar] = c;
                riIndexChar++;
            }
        }
    }

    return 0;
}

int main()
{
    // setup
    g_serial.baud(9600);
    wait(0.001);
    g_lcd.cls(); wait(0.001);
    g_lcd.printf( "(ready)" );
    
    // loop
    int iCounter = 0;
    char szReadBuffer[READBUFFERSIZE] = "";
    int iIndexChar = 0;
    while(1)
    {
        // send
        g_serial.printf( "%d\n", iCounter );
        iCounter++;
        wait(1.0);
        
        // read
        char szLineString[READBUFFERSIZE];
        if( !ReadLineString( g_serial, 
                             szReadBuffer, READBUFFERSIZE, iIndexChar,
                             szLineString, READBUFFERSIZE ) )
        {
            continue;
        }
        g_lcd.cls(); wait(0.001);
        g_lcd.locate(0, 0);
        g_lcd.printf( szLineString );
    }
}
