/*************************************************************
  Download latest Blynk library here:
    https://github.com/blynkkk/blynk-library/releases/latest
  Blynk is a platform with iOS and Android apps to control
  Arduino, Raspberry Pi and the likes over the Internet.
  You can easily build graphic interfaces for all your
  projects by simply dragging and dropping widgets.
    Downloads, docs, tutorials: http://www.blynk.cc
    Sketch generator:           http://examples.blynk.cc
    Blynk community:            http://community.blynk.cc
    Social networks:            http://www.fb.com/blynkapp
                                http://twitter.com/blynk_app
  Blynk library is licensed under MIT license
  This example code is in public domain.
 *************************************************************
  This example shows how to use Arduino.org Ethernet Shield 2 (W5500)
  to connect your project to Blynk.
  NOTE: You may have to install Arduino.ORG IDE to get it working:
          http://www.arduino.org/software
        Pins 10, 11, 12 and 13 are reserved for Ethernet module.
        DON'T use them in your sketch directly!
  Feel free to apply it to any other example. It's simple!
 *************************************************************/

/* Comment this out to disable prints and save space */
#define BLYNK_PRINT Serial
#define WS2812_BUF 8

#include "WS2812.h"
#include "mbed.h"
#include <SPI.h>
#include "EthernetInterface.h"
#include <BlynkSimpleEthernet2.h>

WS2812 ws(D2, WS2812_BUF, 0, 1, 1, 0);

void getBuf(int buf[], int NUM, uint8_t r, uint8_t g, uint8_t b);
uint32_t Wheel(uint8_t WheelPos);

// You should get Auth Token in the Blynk App.
// Go to the Project Settings (nut icon).
char auth[] = "5f3177d2555a42188845f99ebc0d76ad";

int colorbuf[WS2812_BUF];
int offbuf[WS2812_BUF];

BLYNK_WRITE(V0)
{
    int d = param.asInt();
    printf("on/off button value : %d\r\n", d);
    if(d==0) ws.write(colorbuf);
    else ws.write(offbuf);
}

BLYNK_WRITE(V1)
{
    int d = param.asInt();
    printf("brightness value : %d\r\n", d);
    ws.useII(WS2812::GLOBAL);
    ws.setII(d);
    ws.write(colorbuf);
}

BLYNK_WRITE(V2)
{
    int r = param[0].asInt();
    int g = param[1].asInt();
    int b = param[2].asInt();
    printf("rgb value : %d %d %d\r\n", r, g, b);
    getBuf(colorbuf, WS2812_BUF, (uint8_t)r, (uint8_t)g, (uint8_t)b);
    ws.write(colorbuf);
}

BLYNK_WRITE(V3)
{
    int d = param.asInt();
    printf("rainbow button value : %d\r\n", d);
    if(d){
         for(int j=0; j<256*5; j++) { 
            for(int i=0; i< WS2812_BUF; i++) {
                colorbuf[i]=Wheel(((i * 256 / WS2812_BUF) + j) & 255);
            }
            ws.write(colorbuf);
            wait_ms(20);
        }
    }
}


int main(void) {
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0xff, 0xff, 0x48};   
    printf("Hello\r\n");
    getBuf(offbuf, WS2812_BUF, 0x00, 0x00, 0x00);
    getBuf(colorbuf, WS2812_BUF, 0xff, 0xff, 0xff);
    
    Blynk.begin(auth, "blynk-cloud.com", 8442, mac_addr);
    printf("Blynk init!\r\n");
    while(1){
        Blynk.run();
    }    
}

void getBuf(int buf[], int NUM, uint8_t r, uint8_t g, uint8_t b){
    for(int i=0; i<NUM; i++) {
        buf[i]=0;
        buf[i] |= (r<<16 & 0xff0000);
        buf[i] |= (g<<8 & 0x00ff00);
        buf[i] |= (b & 0x0000ff);
    }
}

//255가지의 색을 나타내는 함수
uint32_t Wheel(uint8_t WheelPos) {
  uint32_t data;
  if(WheelPos < 85) {
   data=(((WheelPos * 3)<<16) & 0xff0000) | (((255 - WheelPos * 3)<<8) & 0x00ff00 ) | (0 & 0x0000ff);
  }
  
  else if(WheelPos < 170) {
   WheelPos -= 85;
   data= (((255-WheelPos * 3)<<16) & 0xff0000)| ((0<<8) & 0x00ff00 ) | ((WheelPos * 3) & 0x0000ff);
  }
  
  else {
   WheelPos -= 170;
    data= ((0<<16) & 0xff0000)| (((WheelPos * 3)<<8) & 0x00ff00 ) | ((255-WheelPos * 3) & 0x0000ff);
  }
  return data;
}