
#include "mbed.h"
#include "iostream"
#include "GPS.h"

// Configuracion de los puertos del microcontrolador
Serial gsm(PTE22, PTE23);                             // puerto serie para la comunicacíón GSM
Serial pc(USBTX, USBRX);                            // puerto serie para debug
GPS gps(PTE0, PTE1);                                // puerto para comunicacion GPS

// Declaracion de variables globales
char buffer[200], pdu[] = "", vector1[] = "", vector2[] = "", dE[255], dS[255], dEs[255], dSs[255]; 
char Ctamanosms[1], Ctiposmsc[1],  Csmscnumber[12], Cdeliver[1];
char Ctamanoaddress[1], Ctipoaddress[1], Cnumero[12], Cprotocolo[1], Cencoding[1];
char Ctime[14], Ctamano[1], Cdato[30], Xnumero[10];
int i, k, c, w, r, ta, tam, lenOUT, lenIN;          // variables auxiliares
float lon, lat;                                     // variables para almacenar coordenadas
char link[]= {"http://maps.google.com/?q="};        // inicio trama mensaje

// Rutina principal
int main()
{
    pc.printf("###ss###################### INICIO DEL PROGRAMA #########################");                   // mensaje de bienvenida debug
    // Establecimiento de la comunicacion con el modem del telefono movil
    pc.printf("\r\n>>>>>>>>>>>>>>>>>>>>>> Configurando SIEMENS A56i <<<<<<<<<<<<<<<<<<<<<<\r\n");           // mensaje debug
    gsm.baud(9600);
    gsm.format(8,Serial::None,1);
    std::string strOK ("OK");
    pc.printf("\r\n Enviamos AT \r\n");                                                                     // prueba comunicacion con el movil
    gsm.printf("AT\r\n");
    gsm.scanf("%s",buffer);
    gsm.scanf("%s",buffer);
    pc.printf("%s\n",buffer);

    if(strOK.compare(buffer) != 0) {
        pc.printf("\r\nModem GSM no responde\r\n");
    }

    gsm.printf("\n AT+CNMI=1,1\r\n");                                                                       // Selecciona la memoria de la simcard
    pc.printf("AT+CNMI=1,1\r\n");
    gsm.scanf("%s",buffer);
    gsm.scanf("%s",buffer);
    pc.printf(">%s\n",buffer);
    if(strOK.compare(buffer) != 0) {
        pc.printf("\r\nModem GSM no responde\r\n");
    }

    gsm.printf("\n AT+CPMS= \"SM\",\"SM\",\"SM\"\r\n");  //
    pc.printf("AT+CPMS= \"SM\",\"SM\",\"SM\"\n");
    gsm.scanf("%s",buffer);
    gsm.scanf("%s",buffer);
    gsm.scanf("%s",buffer);
    pc.printf(">%s\n",buffer);
    wait(1);

    gsm.printf("\n AT+CMGF=0\r\n");                                                                         // Configura modo PDU
    pc.printf("AT+CMGF=0\r\n");
    gsm.scanf("%s",buffer);
    gsm.scanf("%s",buffer);
    pc.printf(">%s\n",buffer);

    if(strOK.compare(buffer) != 0) {
        pc.printf("\r\nModem GSM no responde\r\n");
    }

    pc.printf("\n CBST=0,0,1\r\n");
    gsm.printf("CBST=0,0,1\r\n");                                                                           // en espera de mensajes entrantes

    if(gps.sample()) {
        pc.printf("Estamos en %f, %f\r\n", gps.latitude, gps.longitude+50);                                 // muestro la ubicacion actual, para saber si el GPS esta recibiendo
    } else {
        pc.printf("no se donde!:(\r\n");
    }
    
// Ciclo infinito
    while(1) {

        pc.printf("\r\n>>>>>>>>>>>>>>>>>> Esperando nuevo mensaje de texto <<<<<<<<<<<<<<<<<<<\r\n");
        gsm.scanf("%s",buffer);
        pc.printf("%s",buffer);
        i = strlen(buffer);

        if(i>3) {                                                                                           // si reciba un mensaje
            pc.printf("\r\n>>>>>>>>>>>>>>>>>>>>>>>>>>>> Nuevo mensaje <<<<<<<<<<<<<<<<<<<<<<<<<<<<\r\n");
            gsm.printf("AT+CMGR=1\r\n");                                                                    // lee menjsae en la primera posicion de memoria
            gsm.scanf("%s",buffer);
            gsm.scanf("%s",buffer);
            gsm.scanf("%s",buffer);
            gsm.scanf("%s",buffer);
            pc.printf(">%s \r\n",buffer);                                                                   // imprime la cadena PDU del mensaje
            tam = strlen(buffer);                                                                           // longitud del mensaje leido
            pc.printf("\r\nLectura de la trama PDU: %d\r\n", tam);                                          // separa la trama pdu para extraer informacion necesaria
            Ctamanosms[0] = buffer[0];                                                                      // tamaño en septetos de toda la trama pdu
            Ctamanosms[1] = buffer[1];
            pc.printf("\r\nLongitud del mensaje en septetos %c%c en septetos \n", Ctamanosms[0], Ctamanosms[1]);
            Ctiposmsc[0] = buffer[2];
            Ctiposmsc[1] = buffer[3];
            pc.printf("\r\nTipo de direccion SMSC %c%c   \r\n",  Ctiposmsc[0], Ctiposmsc[1]);
            Csmscnumber[0] = buffer[4];
            Csmscnumber[1] = buffer[5];
            Csmscnumber[2] = buffer[6];
            Csmscnumber[3] = buffer[7];
            Csmscnumber[4] = buffer[8];
            Csmscnumber[5] = buffer[9];
            Csmscnumber[6] = buffer[10];
            Csmscnumber[7] = buffer[11];
            Csmscnumber[8] = buffer[12];
            Csmscnumber[9] = buffer[13];
            Csmscnumber[10] = buffer[14];
            Csmscnumber[11] = buffer[15];
            pc.printf("\r\nNumero del SMSC %s \r\n",  Csmscnumber);
            Cdeliver[0] = buffer[16];
            Cdeliver[1] = buffer[17];
            Ctamanoaddress[0] = buffer[18];
            Ctamanoaddress[1] = buffer[19];
            Ctipoaddress[0] = buffer[20];
            Ctipoaddress[1] = buffer[21];
            Cnumero[0] = buffer[22];                                                                             // Numero del usuario
            Cnumero[1] = buffer[23];
            Cnumero[2] = buffer[24];
            Cnumero[3] = buffer[25];
            Cnumero[4] = buffer[26];
            Cnumero[5] = buffer[27];
            Cnumero[6] = buffer[28];
            Cnumero[7] = buffer[29];
            Cnumero[8] = buffer[30];
            Cnumero[9] = buffer[31];
            Cnumero[10] = buffer[32];
            Cnumero[11] = buffer[33];
            Xnumero[0] = buffer[23];
            Xnumero[1] = buffer[22];
            Xnumero[2] = buffer[25];
            Xnumero[3] = buffer[24];
            Xnumero[4] = buffer[27];
            Xnumero[5] = buffer[26];
            Xnumero[6] = buffer[29];
            Xnumero[7] = buffer[28];
            Xnumero[8] = buffer[31];
            Xnumero[9] = buffer[30];
            pc.printf("\r\nNumero del usuario %s \r\n",  Xnumero);
            Cprotocolo[0] = buffer[34];                                                                          // protocolo
            Cprotocolo[1] = buffer[35];
            Cencoding[0] = buffer[36];                                                                           // cifrado
            Cencoding[1] = buffer[37];
            Ctime[0] = buffer[38];                                                                               // Tiempo envio mensaje
            Ctime[1] = buffer[39];
            Ctime[2] = buffer[40];
            Ctime[3] = buffer[41];
            Ctime[4] = buffer[42];
            Ctime[5] = buffer[43];
            Ctime[6] = buffer[44];
            Ctime[7] = buffer[45];
            Ctime[8] = buffer[46];
            Ctime[9] = buffer[47];
            Ctime[10] = buffer[48];
            Ctime[11] = buffer[49];
            Ctime[12] = buffer[50];
            Ctime[13] = buffer[51];
            Ctamano[0]= buffer[50];                                                                             // longitud de la parte legible
            Ctamano[1]= buffer[51];
            ta = (Ctamano[0]-48)*16+(Ctamano[1]-48);
            pc.printf("\r\nNumero de caracteres del mensaje entrante %d \r\n", ta);
            pc.printf("\r\nPosicion de los datos en el mensaje PDU  %d \r\n", tam-2*ta);                        // posicion de los datos en la trama pdu
            for(i = 0; i < 2*ta; i++) {                                                                         //Toma de los datos o mensaje
                Cdato[i] = buffer[52+i];
            }
            // Inicia la convercion de PDU a Texto
            pc.printf("\r\n>>>>>>>>>>>>>>>>>>>>> Convirtiendo de PDU a texto <<<<<<<<<<<<<<<<<<<<<\r\n");
            lenIN = strlen(Cdato)/2;
            w = 0;
            pc.printf("\r\nTamano de los datos %d \r\n", strlen(Cdato));
            for(i = 0; i <= strlen(Cdato); i++) {
                if(i%2==0) {
                    if(Cdato[i]>47 & Cdato[i]<58) {                                                             // primero se asigna el valor numerico de cada caracter en caso de ser 0-9 se le resta 48 en caso de ser letra se le resta 55
                        Cdato[i] = Cdato[i]-48;
                    }

                    if(Cdato[i]>65 & Cdato[i]<71) {
                        Cdato[i] = Cdato[i]-55;

                    }

                } else {
                    if(Cdato[i]>47 & Cdato[i]<58) {
                        Cdato[i] = Cdato[i]-48;
                    }

                    if(Cdato[i]>65 & Cdato[i]<71) {
                        Cdato[i] = Cdato[i]-55;

                    }

                    dE[w] = Cdato[i-1]*16+Cdato[i];
                    pc.printf("\r\nDatos en hexagesimal DE[%d] %2X \r\n", w, dE[w]);                            // Se guarda la dupla en el vector dE
                    w++;
                }
            }
            lenOUT = lenIN*8/7;
            k = 7;
            c = 0;
            dS[0] = dE[0] & 0x7F;
            pc.printf("%2X,%d,%d\r\n",dS[0],i,k);
            for (i = 1; i < lenOUT; i++) {                                                                      // inicia el algoritmo
                dS[i] = (dE[i-1-c]>>k | dE[i-c]<<(8-k))& 0x7F;
                pc.printf("%2X,%d,%d\r\n",dS[i],i,k);
                if (k==0) {
                    k = 8;
                    c++;
                }
                k--;
            }
            dS[10] = dS[10] + 112;
            
            pc.printf("\r\nMensaje entrante: ");
            for (i = 0; i < lenOUT; i++) {
                pc.printf("%c",dS[i]);
            }
            pc.printf("\r\n>>>>>>>>>>> Termina convercion de los datos de PDU a texto <<<<<<<<<<<<\r\n");
        }
        
        
        std::string strC ("Coordenadas");                                                                        // cadenas para comparar el mensaje recibido

        if(strC.compare(dS) == 0) {                                                                             // En caso de que se pidan las coordenadas
            pc.printf("\r\n>>>>>>>>>>>>>>>>>>>>>>>> Recibido: Coordenada <<<<<<<<<<<<<<<<<<<<<<<<<\n");
            pc.printf("\r\nEsperando GPS \r\n");


            while(1) {
                i = 0;
                if(gps.sample() && i == 0) {
                    pc.printf("\r\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>> Leyendo GPS <<<<<<<<<<<<<<<<<<<<<<<<<<<<<\r\n");
                    //Toma de datos del gps y concatenacion para armar los datos.
                    lon = gps.longitude+50;
                    lat = gps.latitude;
                    sprintf(vector1, "%f", lat);
                    strcat(link,vector1);
                    strcat(link,",");
                    sprintf(vector2, "%f", lon);
                    strcat(link,vector2);
                    strcat(dEs,link);
                    pc.printf("%s\n",link);
                    // Conversion de los datos "link" a formato PDU
                    lenIN = strlen(dEs);
                    k = 0;
                    c = 0;
                    for (i = 0; i < lenIN; i++) {
                        dSs[i] = dEs[i+c]>>k | dEs[i+c+1]<<(7-k);
                        if (dSs[i]==0x00) {
                            lenOUT = i;
                            goto salir;
                        }
                        k++;
                        if (k==7) {
                            k = 0;
                            c++;
                        }
                    }

salir:
                    pc.printf("DEs\n");
                    for (i = 0; i < lenIN; i++) {
                        pc.printf("%X",dEs[i]);
                    }
                    pc.printf("\n DSs \n");
                    for (i = 0; i<lenOUT; i++) {
                        pc.printf("%02X",dSs[i]&0x000000FF);
                    }

                    pc.printf("\n lenOUT:%d,lenIN:%d\r\n",lenOUT,strlen(dEs));
                    pc.printf("\r\n>>>>>>>>>>>>>>>>> Comienza el envio del mensaje SMS <<<<<<<<<<<<<<<<<<\r\n");

                    if(lenOUT%2==0) {
                        w = 27;
                    } else {
                        w = 26;
                    }
                    gsm.printf("AT+CMGS=%d\r\n", ((2*lenOUT)+w)/2);                                             // Inicia envio del mensaje
                    //pc.printf("\n AT+CMGS=%d\r\n", ((2*lenOUT)+w)/2);
                    wait(0.5);

                    gsm.printf("0011000A91");                                                                   // relleno inicial
                    //pc.printf("0011000A91");


                    for(i = 0; i < 11; i++) {                                                                   // numero de destino
                        gsm.printf("%c", Cnumero[i]);
                      //  pc.printf("%c", Cnumero[i]);

                    }

                    gsm.printf("000AA");                                                                        // segundo relleno
                    //pc.printf("000AA");

                    gsm.printf("%2X",lenIN);                                                                    // longitud de los datos
                    //pc.printf("%2X",lenIN);


                    for (i = 0; i < lenOUT; i++) {
                        gsm.printf("%02X",dSs[i]&0x000000FF);
                      //  pc.printf("%02X",dSs[i]&0x000000FF);
                        //wait(0.1);
                    }
                    gsm.putc((char)0x1A);
                    gsm.scanf("%s",buffer);                                                                     // lectura respuesta del modem
                    gsm.scanf("%s",buffer);
                    //pc.printf("\r\nRespuesta movil: %s \r\n",buffer);
                    i = 1;
                    gsm.printf("AT+CMGD=1\r\n");

                    for(i = 26; i <= strlen(link); i++) {
                        link[i] = NULL;

                    }

                    for(i = 0; i <= 255; i++) {
                        dSs[i] = NULL;
                        dEs[i] = NULL;
                    }

                    pc.printf("\r\n Se sale de while  para la lectura de gps \r\n ");
                    gsm.scanf("%s",buffer);
                    pc.printf(">%s",buffer);
                    goto xt;
                }
            }
        }

        if(strC.compare(dS) != 0) {
            pc.printf("\r\nMensaje no valido\r\n");
            gsm.printf("AT+CMGD=1\r\n");                                                                    // Borrar el mensaje
            gsm.scanf("%s",buffer);
            pc.printf("\n%s\n",buffer);
        }

xt:
        gsm.scanf("%s",buffer);
        pc.printf("%s",buffer);
    }
}