#include "mbed.h"
#include "Rtc_Ds1307.h"
#include "TextLCD.h"

void Rx_interrupt();

//RtcCls rtc(p28, p27, p29, true);
Rtc_Ds1307 rtc(PTE0,PTE1);//sda,scl
TextLCD lcd(PTB0, PTB1, PTB2, PTB3, PTC2, PTC1); // rs, e, d4, d5, d6, d7
Serial pc(USBTX, USBRX, "pc");
DigitalOut led1(LED1);
char c;
char buffer[128];
int readptr = 0;

int main() {
    
    pc.attach(&Rx_interrupt, Serial::RxIrq);
    Rtc_Ds1307::Time_rtc tm = {};
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Time: ");
    lcd.locate(0,1);
    lcd.printf("Date: ");
    
    
    while(1) {
        /*pc.printf("*************************************\n");
        pc.printf("* Menu for RTC Test :               *\n");
        pc.printf("* read  - reads the clock           *\n");
        pc.printf("* start - start the clock           *\n");
        pc.printf("* stop  - stop the clock            *\n");
        pc.printf("* write - write the clock           *\n");
        pc.printf("* ena   - enable Square wave output *\n");
        pc.printf("* dis   - disable square wave outp. *\n");
        pc.printf("*************************************\n");*/
        
        led1 = !led1;
        wait(1);
        if (rtc.getTime(tm) ) {
                lcd.locate(6,0);
                lcd.printf("%02d:%02d:%02d", tm.hour, tm.min, tm.sec);
                lcd.locate(6,1);
                lcd.printf("%02d/%02d/%04d", tm.date, tm.mon, tm.year);
            }
        
        
        if (strncmp(buffer, "read", 4) == 0) {
            //  perform read
            pc.printf("Performing read operation\n");
            if (rtc.getTime(tm) ) {
                pc.printf("The current time is : %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);
                pc.printf("The current date is : %s, %02d/%02d/%04d\n", rtc.weekdayToString(tm.wday), tm.mon, tm.date, tm.year);
            }
            buffer[0] = 'z';
        }
        else if (strncmp(buffer, "start", 5) == 0) {
            //  start
            pc.printf("Performing start operation\n");
            rtc.startClock();
            buffer[0] = 'z';
        }
        else if (strncmp(buffer, "stop", 4) == 0) {
            //  stop
            pc.printf("Performing stop operation\n");
            rtc.stopClock();
            buffer[0] = 'z';
        }
        else if (strncmp(buffer, "ena", 3) == 0) {
            int rs;
            pc.printf("Please specify the frequency : [0 = 1Hz, 1 = 4.096kHz, 2 = 8.192kHz, 3 = 32.768kHz] ");
            scanf("%d", &rs);
            pc.printf("Enabling the output with %d option\n", rs);
            rtc.setSquareWaveOutput(true, (Rtc_Ds1307::SqwRateSelect_t)rs);
            buffer[0] = 'z';
        }
        else if (strncmp(buffer, "dis", 3) == 0) {
            pc.printf("Disableing square wave output\n");
            rtc.setSquareWaveOutput(false, Rtc_Ds1307::RS1Hz);
            buffer[0] = 'z';
        }
        else if (strncmp(buffer, "write", 5) == 0) {
            //  perform write
            tm.date = ((buffer[6] - 48)*10) + (buffer[7] - 48);
            tm.mon = ((buffer[8] - 48)*10) + (buffer[9] - 48);
            tm.year = ((buffer[10] - 48)*1000) + ((buffer[11] - 48)*100) + ((buffer[12] - 48)*10) + (buffer[13] - 48);
            tm.hour = ((buffer[14] - 48)*10) + (buffer[15] - 48);
            tm.min = ((buffer[16] - 48)*10) + (buffer[17] - 48);
            tm.sec = ((buffer[18] - 48)*10) + (buffer[19] - 48);
            /*pc.printf("Enter the date (date 0..31)");
            pc.scanf("%d", &tm.date);
            pc.printf("Enter the date (month 1..12)");
            pc.scanf("%d", &tm.mon);
            pc.printf("Enter the date (year)");
            pc.scanf("%d", &tm.year);
            pc.printf("Enter the time (hours 0..23)");
            pc.scanf("%d", &tm.hour);
            pc.printf("Enter the time (minutes 0..59)");
            pc.scanf("%d", &tm.min);
            pc.printf("Enter the time (seconds 0..59)");
            pc.scanf("%d", &tm.sec);
            pc.printf("Performing write operation\n");
            
            //while(pc.readable()) 
              //  pc.getc();*/
            rtc.setTime(tm, false, false);
            buffer[0] = 'z';
        }
        /*else {
            pc.printf("syntax error\n");
        }
        readptr = 0;
        pc.printf("\n\n\n");*/
    }
}



void Rx_interrupt() {
   
    while( (c = pc.getc()) != '\n') {
            buffer[readptr++] = c;
        }
        buffer[readptr++] = 0;
        readptr = 0;
    return;
    }