#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"
#include "QEI.h"
#include "Rtc_Ds1307.h"
#include <Pulse1.h>

TextLCD lcd(PTB0, PTB1, PTB2, PTB3, PTC2, PTC1); // rs, e, d4, d5, d6, d7
Rtc_Ds1307 rtc(PTE0, PTE1);
QEI wheel (PTD7, PTD6, NC, 30);
DebouncedIn button_enco(PTC5);
PwmOut Sonido(PTD1);
PulseInOut irda(PTD5);// en este puerto se pone el sensor infrarrojo


float periodo;
float Frecuencia = 4000; 
int C1 = 0x0C;
int m = 0, flag = 0;
uint8_t pot[7] = {1, 2, 4, 8, 16, 32, 64};
uint8_t pot1[7] = {254, 253, 251, 248, 239, 223, 191};
int Lugar = 0; // Definen el punto en el cual va el programa
int i = 0, j = 0;
int pos = 0;   // Reloj:0, Alarma1:1, Alarma2:2, ... , Alarma7:7
uint8_t state_alarms = 0, pos_alarm = 0, alarma = 0; 

//irda
int header = 0; //tiempo de cabecera pulso abajo 
const int head_H = 4532; //+20% medida con osciloscopio en microsegundos
const int head_L = 4494;//-20%  medida con osciloscopio
int g = 0, h = 0, count = 0;
const int T_alto = 1600;//ponga su tiempo de la prueba
const int T_bajo = 485;//ponga su tiempo de la prueba
const int num_bits = 32;//ponga su numero de bits
int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos
int sec[num_bits];//cadena para almacenar la cadena codificada en binario
int dato; // tiempo de cada dato que se lee
int boton_sel = 10;
int boton[10][32]= {{1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,1,1,0,1,1,0},      //0
                    {1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,0},      //1
                    {1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,1,1,0},      //2
                    {1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,1,1,1,1,0},      //3
                    {1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,1,1,1,0},      //4
                    {1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,1,1,1,0},      //5
                    {1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,1,0,1,1,1,0},      //6
                    {1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,0},      //7
                    {1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,1,0,1,1,0,0,0,0,0,1,0,0,1,1,1,0},      //8
                    {1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,1,1,1,0}};     //9


int main()
{
    Rtc_Ds1307::Time_rtc tm = {};
    Rtc_Ds1307::Time_rtc Alarm[7] = {};
    lcd.cls();
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
    lcd.locate(0,0);
    periodo=(1/Frecuencia);
    Sonido.period(periodo);
    rtc.getTime(tm); //lee el tiempo del DS1307
    Sonido.write(255);


    while(1)
    {
        switch (Lugar)
        {   
            case 0:
            
                rtc.getTime(tm);
                m = wheel.getPulses();
                if(m != 0)
                    {                        
                        wheel.reset();  
                        pos = pos + m;
                        m = 0;        
                        lcd.cls();                               
                    }
                if(pos > 7)
                    {                        
                        pos = -1;                                       
                    }
                if(pos < -1)
                    {                        
                        pos = 7;                                       
                    }    
                if(pos == 0)
                {   
                    lcd.locate(0,0);                        
                    lcd.printf("Time:   ");
                    lcd.locate(8,0);    
                    lcd.printf("%02d:",tm.hour);
                    lcd.printf("%02d:",tm.min);
                    lcd.printf("%02d",tm.sec);   
                    lcd.locate(0,1);
                    lcd.printf("%02d/",tm.mon);
                    lcd.printf("%02d/",tm.date);
                    lcd.printf("%02d",tm.year);
                    wait(0.1);
                }
                
                if(pos == -1)
                {   
                    lcd.locate(0,0);                        
                    lcd.printf("Alarm Setup IRDA");
                    wait(0.1);
                }
                
                
                if(pos > 0)
                {
                    lcd.locate(0,0);    
                    lcd.printf("Alarm %d", pos);
                    lcd.locate(8,0);    
                    lcd.printf("%02d:",Alarm[pos - 1].hour);
                    lcd.printf("%02d:",Alarm[pos - 1].min);
                    lcd.printf("%02d",Alarm[pos - 1].sec);  
                    lcd.locate(0,1);
                    lcd.printf("%02d/",Alarm[pos - 1].mon);
                    lcd.printf("%02d/",Alarm[pos - 1].date);
                    lcd.printf("%02d",Alarm[pos - 1].year);
                    lcd.locate(13,1);
                    if((state_alarms&(pot[pos - 1])) == pot[pos - 1])
                    {
                        lcd.printf("On ");
                    }
                    else
                    {
                        lcd.printf("Off");
                    }
                    
                    wait(0.1);
                }
                for(j=0;j<7;j++)
                {
                    if( (tm.date==Alarm[j].date)&&(tm.mon==Alarm[j].mon)&&(tm.year==Alarm[j].year)&&(tm.hour==Alarm[j].hour)&&(tm.min==Alarm[j].min)&&(tm.sec==Alarm[j].sec)&&((state_alarms&(pot[j])) == pot[j]))
                    {
                        Lugar = 2;
                        lcd.cls();
                        lcd.locate(0,0);                        
                        lcd.printf("Active Alarm%d!!!",(j+1));
                        lcd.locate(0,1);
                        lcd.printf("->Disable ");                       
                        lcd.locate(10,1);                   
                        lcd.printf("--5min");
                        pos_alarm = j;
                    }
                }
                
                if (button_enco.falling())      //si se pulsa boton encoder
                {  
                    if(pos == -1)
                    {Lugar = 3;
                    lcd.cls();}
                    else
                        {Lugar = 1;}
                
                }
             
            break;
            
            case 1:
                switch(i)
                {
                    case 0:
                        if(pos == 0)
                        {
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Time Setup");                           
                        } 
                                              
                        if(pos > 0)
                        {
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Alarm %d Setup", pos);                             
                        }  
                        wait(1);
                        i++;
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Day: ");
                    break;
                    
                    case 1:
                        m = wheel.getPulses();        
                        if (m != 0) 
                        {
                            tm.date = tm.date + m;
                            if(tm.date > 31)
                            {
                                tm.date = 1;
                            }
                            if(tm.date < 1)
                            {
                                tm.date = 31;
                            }
                            wheel.reset();  
                            m = 0;
                        }
                        lcd.locate(5,0);
                        lcd.printf("%02d",tm.date);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Month: ");
                        }
                    break;
                    
                    case 2:
                        m = wheel.getPulses();        
                        if (m != 0) 
                        {
                            tm.mon = tm.mon + m;
                            if(tm.mon > 12)
                            {
                                tm.mon = 1;
                            }
                            if(tm.mon < 1)
                            {
                                tm.mon = 12;
                            }
                            wheel.reset();  
                            m = 0;
                        }
                        lcd.locate(7,0);
                        lcd.printf("%02d",tm.mon);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Year: ");
                        }
                    break;
                    
                    case 3:
                        m = wheel.getPulses();        
                        if (m != 0) 
                        {
                            tm.year = tm.year + m;
                            if(tm.year < 2000)
                            {
                                tm.year = 2000;
                            }
                            wheel.reset();  
                            m = 0;
                        }
                        lcd.locate(6,0);
                        lcd.printf("%02d",tm.year);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Hours: ");
                        }
                    break;
                    
                    case 4:
                        m = wheel.getPulses();    
                        if (m != 0) 
                        {
                            tm.hour = tm.hour + m;
                            if(tm.hour > 23)
                            {
                                tm.hour = 0;
                            }
                            if(tm.hour < 0)
                            {
                                tm.hour = 23;
                            }
                            wheel.reset();  
                            m = 0;
                        }
                        lcd.locate(7,0);
                        lcd.printf("%02d",tm.hour);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Minutes: ");
                        }
                    
                    break;
                    
                    case 5:
                        m = wheel.getPulses();        
                        if (m != 0) 
                        {
                            tm.min = tm.min + m;
                            if(tm.min > 59)
                            {
                                tm.min = 0;
                            }
                            if(tm.min < 0)
                            {
                                tm.min = 59;
                            }
                            
                            wheel.reset();  
                            m = 0;
                        }
                        lcd.locate(9,0);
                        lcd.printf("%02d",tm.min);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Seconds: ");
                        }
                    break;
                    
                    
                    case 6:
                        m = wheel.getPulses();        
                        if (m != 0) 
                        {
                            tm.sec = tm.sec + m;
                            if(tm.sec > 59)
                            {
                                tm.sec = 0;
                            }
                            if(tm.sec < 0)
                            {
                                tm.sec = 59;
                            }
                            wheel.reset();  
                            m = 0;
                        }
                        lcd.locate(9,0);
                        lcd.printf("%02d",tm.sec);
                        
                        if (button_enco.falling())
                        {
                            if(pos==0)
                            {
                                rtc.setTime(tm, false, false);
                                rtc.startClock();
                                lcd.cls();
                                lcd.locate(0, 0);
                                lcd.printf("Time Set");      
                                wait(1);
                                i = 0;
                                Lugar = 0;
                                lcd.cls();                      
                            } 
                            if(pos > 0)
                            {
                                i++;
                                lcd.cls();
                                lcd.locate(0,0);
                                lcd.printf("Enable: Off");
                            }                          
                        }
                    break;
                    
                    case 7:
                        m = wheel.getPulses();        
                        if (m != 0) 
                        {
                            if(flag == 0)
                            {
                                lcd.locate(8,0);
                                lcd.printf("On ");
                                flag = 1;           //se activa la alarma
                            }
                            else 
                            if(flag == 1)
                            {
                                lcd.locate(8,0);
                                lcd.printf("Off");
                                flag = 0;           //se desactiva la alarma
                            }
                            wheel.reset();  
                            m = 0;
                        }
                        
                        if (button_enco.falling())
                        {
                            if(flag == 1)
                            {
                                state_alarms = state_alarms | pot[(pos - 1)];
                            }
                            if(flag == 0)
                            {
                                state_alarms = state_alarms & pot1[(pos - 1)];
                            }
                            Alarm[pos - 1] = tm;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Alarm %d Set", pos);
                            wait(1);
                            i = 0;
                            Lugar = 0;
                            flag = 0;
                            lcd.cls();
                        }
                    break;
                }            
            break;
            
            case 2:
                Sonido.write(0.5);
                wait(0.2);
                Sonido.write(255);
                wait(0.2);
                Sonido.write(0.5);
                wait(0.2);
                Sonido.write(255);
                wait(0.2);
                
                m = wheel.getPulses();
                    
                if(alarma == 0)       //pos_alarm
                {   
                    if(m != 0)
                    {                        
                        alarma = 1;
                        wheel.reset();
                        m = 0;
                        lcd.locate(1,1);
                        lcd.printf("-");                    
                        lcd.locate(11,1);
                        lcd.printf(">");                                          
                    }
                }
                
                if(alarma == 1)
                {
                    if(m != 0)
                    {                        
                        alarma = 0;
                        wheel.reset();
                        m = 0;
                        lcd.locate(1,1);
                        lcd.printf(">");                    
                        lcd.locate(11,1);
                        lcd.printf("-");                                          
                    }
                }
                
                if (button_enco.falling())
                {
                    if(alarma == 0)
                    {
                        wheel.reset();
                        m=0;
                        Sonido.write(255);
                        lcd.cls();
                        wait(0.5);
                        
                    }
                    if(alarma==1)
                    {
                        rtc.getTime(tm);
                        if(tm.min >= 55)
                        {
                            Alarm[pos_alarm].min = (tm.min + 5) - 60;
                            Alarm[pos_alarm].hour = tm.hour + 1;
                        }
                        else
                        {
                            Alarm[pos_alarm].min = tm.min + 5;
                        }
                        lcd.cls();
                        alarma=0;
                        
                    }
                    Lugar = 0;
                }
            break;
            
            case 3:
        lcd.locate(0,0);
        lcd.printf("Waiting IRDA");    
        header = 0;
        header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo
        if (header > head_L && header < head_H)//verificar que este en la tolerancia +-20%
        {
            //leo los datos de la trama y se meten a un arreglo
            wait_us(2000);
            for(g = 0; g<(num_bits-1); g++) // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
            {
                dato = irda.read_high_us(); //leer un bit de datos que es pulso arriba en este control
                num[g]=dato;
                 
                wait_us(332);
            }
           
            for(g = 0; g<num_bits; g++)       // guardo la secuancia en binario
            {
                if(num[g] > ((T_alto+T_bajo)/2)){sec[g]=1;}
                else {sec[g]=0;}   
            }
            for(h = 0; h < 8; h++)
            {
                for(g = 0; g < 32; g++)
                {
                    if(sec[g]==boton[h][g]) //en caso de que un bit no coincida se descarta el boton 1
                    {
                        count++;
                        if(count==32)
                        {
                            boton_sel = h - 1;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Alarm %d: ",(boton_sel+1));
                            if(boton_sel >= 0)
                            {
                                if((state_alarms&(pot[boton_sel])) == pot[boton_sel])
                                {
                                    state_alarms = state_alarms & pot1[boton_sel];
                                    lcd.locate(10,0);
                                    lcd.printf("Off");
                                    wait(1.5);
                                    lcd.cls();                      
                                }
                                else
                                {
                                    state_alarms = state_alarms | pot[boton_sel];
                                    lcd.locate(10,0);
                                    lcd.printf("On ");
                                    wait(1.5);
                                    lcd.cls();
                                }
                            }
                            else
                            {
                                Lugar = 0;
                                pos = 0;
                                lcd.cls();
                            }
                        }
                    }
                }
                count = 0;
            }
        }
        
            
            break;
        }             
    }       
}
