#include "mbed.h"
#include "MMA8452.h"
#include "Robot.h"

Serial pc(USBTX,USBRX);

int main() {
    Robot robot;
    double x = 0.0, y = 0.0, z = 0.0, factor = 50.0;
    int offsetx = 63;
    int offsety = 63;
    MMA8452 acc(p9, p10, 40000);
    acc.setBitDepth(MMA8452::BIT_DEPTH_12);
    acc.setDynamicRange(MMA8452::DYNAMIC_RANGE_4G);
    acc.setDataRate(MMA8452::RATE_100);
    while(1) {
        robot.erase();
        if (!acc.isXYZReady()) {
            wait(.01);
        } else {
            acc.readXYZGravity(&x, &y, &z);
            robot.setXPosition(-1 * x * factor + offsetx);
            robot.setYPosition(-1 * y * factor + offsety);
            robot.draw();
        }        
    }
}
