#include <iostream>
#include "uLCD_4DGL.h"
#include "Robot.h"
#include "mbed.h"

uLCD_4DGL uLCD(p28, p27, p29);

Robot::Robot() {
	xPosition = 63;
	yPosition = 63;
}
	
Robot::Robot(int xPos, int yPos): xPosition(xPos), yPosition(yPos) {
}

void Robot::setXPosition(int xPos) {
	xPosition = xPos;
}

void Robot::setYPosition(int yPos) {
	yPosition = yPos;
}

int Robot::getXPosition() {
	return xPosition;
}

int Robot::getYPosition() {
	return yPosition;
}

void Robot::moveForward(int numMove) {
	setYPosition(yPosition + numMove);
}

void Robot::moveBack(int numMove) {
	setYPosition(yPosition - numMove);
}

void Robot::moveRight(int numMove) {
	setXPosition(xPosition + numMove);
}

void Robot::moveLeft(int numMove) {
	setXPosition(xPosition - numMove);
}

void Robot::inputMove() {
	char direction;
	int numSpaces;
	std::cout << "Please enter a direction for the robot to move " 
		<< "(F, B, L, or R), followed by the integer distance: \n";
	std::cin >> direction;
	std::cin >> numSpaces;
	switch (direction) {
	case 'F':
		moveForward(numSpaces);
		std::cout << "Robot is moving forward " << numSpaces << " units.\n";
		break;
	case 'B':
		moveBack(numSpaces);
		std::cout << "Robot is moving backward " << numSpaces << " units.\n";
		break;
	case 'L':
		moveLeft(numSpaces);
		std::cout << "Robot is moving left " << numSpaces << " units.\n";
		break;
	case 'R':
		moveRight(numSpaces);
		std::cout << "Robot is moving right " << numSpaces << " units.\n";
		break;
	default:
		std::cout << "Invalid move.\n";
	}
}

void Robot::displayPosition() {
	std::cout << "Robot is located at x = " << xPosition
		<< ", y = " << yPosition << "\n";
}

void Robot::draw() {
	uLCD.rectangle(Robot::getYPosition() - 5, Robot::getXPosition() - 5,
	 	Robot::getYPosition() + 5, Robot::getXPosition() + 5, WHITE);
	uLCD.rectangle(Robot::getYPosition() - 3, Robot::getXPosition() + 4,
		Robot::getYPosition() + 3, Robot::getXPosition() + 2, WHITE);
	//uLCD.line(this.getX() - 5, this,getY(), this.getX() - 7, this.getY(),
//		WHITE);
//	uLCD.line(this.getX() + 5, this,getY(), this.getX() + 7, this.getY(),
//		WHITE);
//	uLCD.line(this.getX() - 7, this,getY(), this.getX() - 7, this.getY() - 2,
//		WHITE);
//	uLCD.line(this.getX() + 7, this,getY(), this.getX() + 7, this.getY() - 2,
//		WHITE);
	uLCD.line(Robot::getYPosition(), Robot::getXPosition() - 5,
		Robot::getYPosition(), Robot::getXPosition() - 7,WHITE);
	uLCD.circle(Robot::getYPosition() - 2, Robot::getXPosition() - 2, 2, WHITE);
	uLCD.circle(Robot::getYPosition() + 2, Robot::getXPosition() - 2, 2, WHITE);
	uLCD.circle(Robot::getYPosition(), Robot::getXPosition() - 9, 2, WHITE);
}

void Robot::erase() {
	uLCD.rectangle(Robot::getYPosition() - 5, Robot::getXPosition() - 5,
	 	Robot::getYPosition() + 5, Robot::getXPosition() + 5, BLACK);
	uLCD.rectangle(Robot::getYPosition() - 3, Robot::getXPosition() + 4,
		Robot::getYPosition() + 3, Robot::getXPosition() + 2, BLACK);
	uLCD.line(Robot::getYPosition(), Robot::getXPosition() - 5,
		Robot::getYPosition(), Robot::getXPosition() - 7, BLACK);
	uLCD.circle(Robot::getYPosition() - 2, Robot::getXPosition() - 2, 2, BLACK);
	uLCD.circle(Robot::getYPosition() + 2, Robot::getXPosition() - 2, 2, BLACK);
		uLCD.circle(Robot::getYPosition(), Robot::getXPosition() - 9, 2, BLACK);
}