#include "AbstractAsteroid.h"

int asteroidErase[ASTEROID_WIDTH * ASTEROID_HEIGHT] = {
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_
};

int AbstractAsteroid::getXPath() const {
    return xPath;
}

int AbstractAsteroid::getYPath() const {
    return yPath;
}

int AbstractAsteroid::getSpeed() const {
    return speed;
}

void AbstractAsteroid::setXPath(int xPath) {
    this->xPath = xPath;
}

void AbstractAsteroid::setYPath(int yPath) {
    this->yPath = yPath;
}

void AbstractAsteroid::setSpeed(int speed) {
    this->speed = speed;
}


void AbstractAsteroid::draw() {
    uLCD.BLIT(getX() - (ASTEROID_WIDTH / 2), getY() - (ASTEROID_HEIGHT / 2),
        ASTEROID_WIDTH, ASTEROID_HEIGHT, getSprite());
}

void AbstractAsteroid::update() {
    uLCD.BLIT(getX() - (ASTEROID_WIDTH / 2), getY() - (ASTEROID_HEIGHT / 2),
        ASTEROID_WIDTH, ASTEROID_HEIGHT, asteroidErase);
    setX(getSpeed() * (getX() + getXPath()));
    setY(getSpeed() * (getY() + getYPath()));
    int leftBound = getX() - (ASTEROID_WIDTH / 2);
    int topBound = getY() - (ASTEROID_HEIGHT / 2);
    int rightBound = getX() + (ASTEROID_WIDTH / 2);
    int bottomBound = getY() + (ASTEROID_WIDTH / 2);
    if (leftBound < 1 + (getWidth() / 2) || topBound < 1 + (getHeight()  / 2)
        || rightBound > 127 - (getWidth() / 2)
        || bottomBound > 127 - (getHeight() / 2)) {
        setDestroyed(true);
    } 
}