#include "mbed.h"

Ticker flipper;

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
Serial pc(USBTX, USBRX); // tx, rx
Serial mycomms(NC, p25); // Uart1
Serial mycomms2(NC, p27); // Uart2

#define BUFFER_SIZE 36
#define EMPTY 0
#define NOT_EMPTY 1
#define ACK 0x00
#define RET 0xAA
#define NAK 0xFF

unsigned char i = 0;
char buffer[16];
char v101[] = "VEND101";
char v102[] = "VEND102";
char v103[] = "VEND103";
char v104[] = "VEND104";
int  tx_buffer[BUFFER_SIZE][2];
int  tx_buffer_in = 0;
int  tx_buffer_out = 0;
bool tx_buffer_empty_flag = EMPTY;
bool slave_flag = 0;
bool return_flag = 1;

int  rx_buffer[BUFFER_SIZE][2];
int  rx_buffer_in = 0;
int  rx_buffer_out = 0;
bool rx_buffer_empty_flag = EMPTY;

unsigned int time_stamp = 0;

//extern "C" void UART1_IRQHandler(void) /*__irq*/ {
void UART1_isr() {
  volatile uint32_t i;
  volatile uint32_t j;
  volatile uint32_t k;
 
 
  j = LPC_UART1->IIR; // read register to clear flag
  i = LPC_UART1->LSR;
  k = LPC_UART1->RBR;
  
  (void)j;  // eliminate compiler warning
 
  if( !(i & 0x00000004) )                           
     k += 0x00000100;              // parity mark so start msg 

  // Check to see if there is room for this request
  if ((tx_buffer_empty_flag != NOT_EMPTY) || (tx_buffer_in != tx_buffer_out))
  {
    tx_buffer[tx_buffer_in][0] = k;
    tx_buffer[tx_buffer_in][1] = time_stamp;

    // Increment the index head or wrap it back to zero
    if (tx_buffer_in == (BUFFER_SIZE - 1))
      tx_buffer_in = 0;
    else
      tx_buffer_in++;

    tx_buffer_empty_flag = NOT_EMPTY; // Say that the queue is not empty
  }

//  VICVectAddr = 0x00000000;    // dummy write to signal end of interrupt 
    
}

//extern "C" void UART2_IRQHandler(void) /*__irq*/ {
void UART2_isr() {
  volatile uint32_t i;
  volatile uint32_t j;
  volatile uint32_t k;
  
  j = LPC_UART2->IIR; // read register to clear flag
  i = LPC_UART2->LSR;
  k = LPC_UART2->RBR;
  
  (void)j;  // eliminate compiler warning
 
  if( !(i & 0x00000004) )                           
     k += 0x00000100;              // parity mark so start msg 

  // Check to see if there is room for this request
  if ((rx_buffer_empty_flag != NOT_EMPTY) || (rx_buffer_in != rx_buffer_out))
  {
    rx_buffer[rx_buffer_in][0] = k;
    rx_buffer[rx_buffer_in][1] = time_stamp;

    // Increment the index head or wrap it back to zero
    if (rx_buffer_in == (BUFFER_SIZE - 1))
      rx_buffer_in = 0;
    else
      rx_buffer_in++;

    rx_buffer_empty_flag = NOT_EMPTY; // Say that the queue is not empty
  }

//  VICVectAddr = 0x00000000;    // dummy write to signal end of interrupt 
    
}

void flip() 
{
    time_stamp++;
}

int main() {

    flipper.attach(&flip, 0.001); // the address of the function to be attached (flip) and the interval (1 millisecond)
    pc.baud( 921600 );
    mycomms.baud(9600);
    mycomms.format(8, Serial::Forced1, 1);
    mycomms2.baud(9600);
    mycomms2.format(8, Serial::Forced1, 1);
    mycomms.attach( &UART1_isr, Serial::RxIrq );
    mycomms2.attach( &UART2_isr, Serial::RxIrq );

// TEST***************************************************
//
//   rx_buffer[0] = 0x00;
//   rx_buffer[1] = 0x01;
//   rx_buffer[2] = 0x02;
//   rx_buffer[3] = 0x103;
//   rx_buffer[4] = 0xF0;
//   rx_buffer[5] = 0x1CC;
//   
//   rx_buffer_in = 6;
//   rx_buffer_empty_flag = NOT_EMPTY;
//
// TEST***************************************************

//    LPC_UART1->IER = 0x01; // enable Uart1 RX interrupts.
//    LPC_UART2->IER = 0x01; // enable Uart2 RX interrupts.

    while(1) 
    {
//    for (i=0;i<16;i++) {
//        buffer[i]='\0';
//       }
//    if(pc.readable()) 
//    {
//            pc.scanf( "%s", buffer );
//
//
//            if( strcmp(v101, buffer ) == 0 )
//                myled1 = 1;
//            if( strcmp(v102, buffer ) == 0 )
//                myled2 = 1;
//            if( strcmp(v103, buffer ) == 0 )
//                myled3 = 1;
//            if( strcmp(v104, buffer ) == 0 )
//                myled4 = 1;
//
//
//
//    }


        if (tx_buffer_empty_flag == NOT_EMPTY)
        {
            // Dispatch the next byte in the queue
            if( tx_buffer[tx_buffer_out][0] & 0x100 )
            {    
                sprintf( buffer, "\n\r%10u>VMC %02X* ", tx_buffer[tx_buffer_out][1], (unsigned char)tx_buffer[tx_buffer_out][0] );
                slave_flag = 0;
            }    
            else if( slave_flag && (((unsigned char)tx_buffer[tx_buffer_out][0] == ACK) || ((unsigned char)tx_buffer[tx_buffer_out][0] == RET) || ((unsigned char)tx_buffer[tx_buffer_out][0] == NAK)))
            {
                sprintf( buffer, "\n\r%10u>VMC %02X ", tx_buffer[tx_buffer_out][1], (unsigned char)tx_buffer[tx_buffer_out][0] );
                slave_flag = 0;
            }
            else
                sprintf( buffer, "%02X ", (unsigned char)tx_buffer[tx_buffer_out][0] );
            
            pc.printf("%s", buffer );


            // If the OUT index is at the top of the queue set it back to 0
            if (tx_buffer_out == (BUFFER_SIZE - 1))
                tx_buffer_out = 0;
            else    // Else increment the OUT index
                tx_buffer_out++;

            // If the OUT index has reached the IN index, no pending
            if (tx_buffer_out == tx_buffer_in)
                tx_buffer_empty_flag = EMPTY;

        } /* if (buffer_empty_flag == NOT_EMPTY) */

        if (rx_buffer_empty_flag == NOT_EMPTY)
        {
            // Dispatch the next byte in the queue
            if( rx_buffer[rx_buffer_out][0] & 0x100 )
            {
                if( return_flag )
                    sprintf( buffer, "\n\r%10u>PER %02X* ", rx_buffer[rx_buffer_out][1], (unsigned char)rx_buffer[rx_buffer_out][0] );
                else
                    sprintf( buffer, "%02X* ", (unsigned char)rx_buffer[rx_buffer_out][0] );
                return_flag = 1;
                slave_flag = 1;
            }
            else
            {
                if( return_flag )
                {
                    sprintf( buffer, "\n\r%10u>PER %02X ", rx_buffer[rx_buffer_out][1], (unsigned char)rx_buffer[rx_buffer_out][0] );
                    return_flag = 0;
                }    
                else
                    sprintf( buffer, "%02X ", (unsigned char)rx_buffer[rx_buffer_out][0] );
            }
            
            pc.printf("%s", buffer );


            // If the OUT index is at the top of the queue set it back to 0
            if (rx_buffer_out == (BUFFER_SIZE - 1))
                rx_buffer_out = 0;
            else    // Else increment the OUT index
                rx_buffer_out++;

            // If the OUT index has reached the IN index, no pending
            if (rx_buffer_out == rx_buffer_in)
                rx_buffer_empty_flag = EMPTY;

        } /* if (buffer_empty_flag == NOT_EMPTY) */

        myled1 = 0;
        myled2 = 0;
        myled3 = 0;
        myled4 = 0;
    }
}


