#include "mbed.h"

AnalogIn sensor1(PC_1); // Sensor 1
AnalogIn sensor2(PC_2); // Sensor 2

DigitalOut led1(PD_12); // Led Verde
DigitalOut led2(PD_14); // Led Rojo

Serial device(PA_2,PA_3); //Puerto serial

int i = 1;
float T1, T2;

int main() 
{
    device.baud(19200); // Velocidad de Puerto Serial

    while(i<21) // Presentacion de 20 Muestras 
    {
        device.printf("Muestra # %i \n", i);
        
        device.printf("Sensor 1: (%4.2f)\n", sensor1.read());
        T1 = (120*sensor1.read()) + 20; // Calculo Sensor 1 (0V = 20° y 3V = 140°)
        device.printf("Temperatura 1: (%4.2f)\n", T1);
        
        device.printf("Sensor 2: (%4.2f)\n", sensor2.read());
        T2 = (-70*sensor2.read()) + 80; // Calculo Sensor 2 (0V = 80° y 3V = 10°)
        device.printf("Temperatura 2: (%4.2f)\n", T2);
        
        if (T1 > 50) // Encendido Led Verde
        {
            led1 = 1;
        }
        else
        {
            led1 = 0;
        }
        
        if (T2 < 50) // Encendido Led Rojo
        {
            led2 = 1;
        }
        else
            led2 = 0;
        
        device.printf (" \n");
        wait(1); // Espera de 1 seg por Muestra
        i++;
    }
}