#include "mbed.h"
#include "LSM9DS1.h"
#define PI 3.14159


int main()
{
    LSM9DS1 IMU(p9, p10, 0xD6, 0x3C);
    IMU.begin();
    if (!IMU.begin()) {
        printf("Failed to communicate with LSM9DS1.\n");
    }
    IMU.calibrate(1);
        float sumgx = 0;
        float sumgy = 0;
        float sumgz = 0;
        float cgx;
        float cgy;
        float cgz;
        float mingx = 100;
        float mingy = 100;
        float mingz = 100;
        float maxgx = 0;
        float maxgy = 0;
        float maxgz = 0;
        int   n = 0;
    
    while(n<=10000) {

        
        while(!IMU.gyroAvailable());
        IMU.readGyro();
        cgx = IMU.calcGyro(IMU.gx);
        cgy = IMU.calcGyro(IMU.gy);
        cgz = IMU.calcGyro(IMU.gz);
        sumgx += cgx;
        sumgy += cgy;
        sumgz += cgz;
        if(cgx > maxgx) {
        printf("Max gx: %f \n\r %d \n\r",maxgx,n);
            maxgx = cgx;
        }
        if(cgy > maxgy) {
            maxgy = cgy;
        }
        if(cgz > maxgz) {
            maxgz = cgz;
        }
        if(cgx < mingx) {
            mingx = cgx;
        }
        if(cgy < mingy) {
            mingy = cgy;
        }
        if(cgz < mingz) {
            mingz = cgz;
        }
        n++;
    }
    printf("\n");
    printf("Avg gx: %f \n\r",sumgx/n);
    printf("Avg gy: %f \n\r",sumgy/n);
    printf("Avg gz: %f \n\r",sumgz/n);
    printf("Max gx: %f \n\r",maxgx);
    printf("Max gy: %f \n\r",maxgy);
    printf("Max gz: %f \n\r",maxgz);
    printf("Min gx: %f \n\r",mingx);
    printf("Min gy: %f \n\r",mingy);
    printf("Min gz: %f \n\r",mingz);
    return 0;
}