#include "mbed.h"
#include "WatchdogTimer.h"

DigitalOut led(LED1);
WatchdogTimer watchdogTimer(3); //Watchdog timer with 3 second timeout

int main()
{
    Timer timer;
    timer.start();
    
    //NOTE: Ensure your main loop operations don't take longer than the watchdog timeout you set
    while(1)
    {
        //Flash LED for five seconds
        if (timer.read_ms() < 5000)
        {
            led = 1;
            wait(0.2);
            led = 0;
            wait(0.2);
        }
        else
        {
            //Simulate hard fault
            while(1) {}
        }
        
        //Kick the watchdog to reset its timer
        watchdogTimer.kick();
    }
}
