#include "mbed.h"
#include "rtos.h"
#include "Hc05.h"
#include "RawSerialPc.h"


RawSerialPc pc(USBTX, USBRX);    //Per provar si funciona, no cal al programa
Hc05 bt(D8, D2);        //Crea l'objecte bt, connectat als pins D8 (TX) i D2 (RX) (és la connexió sèrie BT)

//Aquest serà el meu fil, que va llegint cada 300ms del HC-05 
void llegir_thread(void const *args) {
    while (true) {
        //Intenta llegir un string, i si el llegeix, el tracta
        if(bt.llegirString())
            bt.tractaString();      
        //Comprova la connexió (mira si ha rebut alguna cosa)
        bt.comprovaConnexio();
        //Temps del Thread que està esperant
        Thread::wait(100);
        
    }
}

//Aquest serà el programa principal
int main() {
    
    Thread thread(llegir_thread);       //Inicia el fil llegir_thread
    //char m[128];                        //Per visualitzar el mode i el timer, no es necessari
    while (true) {
        //pc.enviaString(bt.strLlegit);   //Per veure l'ultim string llegit, no es necessari
        bt.calculaMotors(); //Calcula com s'han de moure els motors
        //snprintf(m, 128, "Mode: %d | timer: %dms", bt.getMode(), bt.getTimer()); //Per visualitzar el mode i el timer, no es necessari
        //pc.enviaString(m);              //Per visualitzar el mode i el timer, no es necessari
        //pc.enviaString(bt.strPos);      //Per visualitzar la posicio on ha d'anar el robot, no es necessari
        if((bt.getMode() == 0) || (bt.getMode() == 1) || (bt.getMode() == 2)) {
            pc.enviaString(bt.strM1);       //String motor1 que s'envia a l'arduino d'en Marcel
            pc.enviaString(bt.strM2);       //String motor2 que s'envia a l'arduino d'en Marcel
            pc.enviaString(bt.strM3);       //String motor3 que s'envia a l'arduino d'en Marcel
        }
        else if (bt.getMode() == 3) {
            ;//Mode automàtic (programa Eva)
        }
        else if (bt.getMode() == 4) {
            ;//Mode mando (programa Marc)
        }
        else {
            pc.enviaString("V000FM1");       //String motor1 que s'envia a l'arduino d'en Marcel
            pc.enviaString("V000FM2");       //String motor2 que s'envia a l'arduino d'en Marcel
            pc.enviaString("V000FM3");       //String motor3 que s'envia a l'arduino d'en Marcel
        }
        Thread::wait(500);              //Temps del Thread que està esperant
    }
}