#include "mbed.h"

class Hc05 : public Serial
{

public:
    Timer timer;
    Hc05(PinName tx, PinName rx) : Serial(tx, rx) {
        baud(115200);
        timer.start();
        //printf("Constructora");
    }
    ~Hc05() {
        timer.stop();
        //printf("Destructora");
    }
    bool enviaString(char* str) {
        if (str[0] != '\0')
            printf("%s", str);
        return true;
    }

    void enviaStringAT(char* str) {
        //baud(38400);
        if (str[0] != '\0')
            printf("%s\r\n", str);
    }
    bool llegirStringAT(char* str) {
        if(readable()) {
            int i=0;
            str[i] = getc();
            //Quan detecta un 10 o un 13 surt del bucle (en el mode AT, envia 13+10)
            while(str[i] != 10 && (i < 128)) {
                i++;
                str[i] = getc();
            }
            str[i]='\0';
            return true;
        } else {
            str[0] = '\0';
            return false;
        }
    }

    bool llegirString(char* str) {
        if(readable()) {
            timer.reset();
            int i=0;
            str[i] = getc();
            if (str[i] == '@')
                return false;
            //Quan detecta un 10 o un 13 surt del bucle (en el mode AT, envia 13+10)
            while(str[i] != 13 && (i < 128)) {
                i++;
                str[i] = getc();
            }
            str[i]='\0';
            return true;
        } else {
            str[0] = '\0';
            return false;
        }
    }

    void modeAT(bool _bool) {
        if (_bool) {
            baud(38400);
        } else {
            baud(115200);
        }
    }

    bool connexioOK() {
        if(timer.read_ms() > 500)
            return false;
        else
            return true;
    }

    void checkConn() {
        if(readable())
            timer.reset();
    }
};

class Pc : public Serial
{
public:
    Pc(PinName tx, PinName rx) : Serial(tx, rx) {
        baud(115200);
        printf("Constructora\n");
    }
    ~Pc() {
        printf("Destructora\n");
    }
    bool enviaString(char* str) {
        if (str[0] != '\0')
            printf("%s\n", str);
        return true;
    }

    bool llegirString(char* str) {
        if(readable()) {
            int i=0;
            str[i] = getc();
            while(str[i] != 13 && (i < 128)) {
                i++;
                str[i] = getc();
            }
            str[i]='\0';
            return true;
        } else {
            str[0] = '\0';
            return false;
        }
    }
};

Pc pc(USBTX, USBRX);
Hc05 bt(D8, D2);

int main()
{
    

    char str[128];
    while(1) {
        if(pc.llegirString(str))
            bt.enviaString(str);
        if(bt.llegirString(str))
            pc.enviaString(str);

        if(!(bt.connexioOK()))
            pc.printf("ERROR DE CONNEXIO\n");
    }

}
