#ifndef MBED_HC05_H
#define MBED_HC05_H

#include "mbed.h"

#define longString 128

class Hc05 : public RawSerial {
    private:
        int mode, vel, ang, m1, m2, m3;
        float x, y;
        Timer timer;
        
    public:
        Hc05(PinName tx, PinName rx);
        ~Hc05();
        char strLlegit[longString];
        char strM1[longString];
        char strM2[longString];
        char strM3[longString];
        char strPos[longString];
        void iniString();
        void enviaString(char* str);
        bool llegirString(); 
        void tractaString();
        int getMode();
        int getVel();
        int getAng();
        void getStringLlegit(char* str);
        void comprovaConnexio();
        int getTimer();
        //Calculs
        void calculaMotors(float S1, float S2, float S3);
        float getM1();
        float getM2();
        float getM3();
        float getX();
        float getY();
        void getStringM1(char* str);
        void getStringM2(char* str);
        void getStringM3(char* str);
};

#endif