#include "mbed.h"

#include "C12832.h"

#include "tank.h"

#include "HCSR04.h"


C12832 lcd(p5, p7, p6, p8, p11);        // LCD screen
PwmOut r (p23);                         // r = red LED
PwmOut g (p24);                         // g = green LED

int main()

{

//welcome message on LCD

    lcd.cls();

    lcd.locate(25,5);

    lcd.printf("Tank Water Level");

    lcd.locate(2,15);

    lcd.printf("Greenhouse Control System");

    wait(2.5);

    lcd.cls();      //clear LCD


    Timer timer;

    {

        HCSR04 sensor(p9, p20);
        sensor.setRanges(0, 500);       // water tank level 500mm



        lcd.print_bm(bitmEmptyTank,80,0);     // print Empty Tank at location x=80, y=0
        lcd.copy_to_lcd();
        //if needed:   lcd.locate(0,10);
        //if needed:   lcd.printf("Min. range = %g cm\n\rMax. range = %g cm\n\r",
        //If needed:   sensor.getMinRange(), sensor.getMaxRange());

        while(true) {
            timer.reset();
            timer.start();
            sensor.startMeasurement();
            while(!sensor.isNewDataReady()) {
                // wait for new data
                // waiting time depends on the distance
            }
            lcd.locate(20,5);
            lcd.printf("Distance:");
            lcd.locate(20,17);
            lcd.printf ("%5.1f mm\r", sensor.getDistance_mm());
            timer.stop();
            wait_ms(500 - timer.read_ms()); // time the loop

            //turn RGB LED red if distance >400mm
  
            if( sensor.getDistance_mm()< 400) r= 1; //red light on
            else r = 0;

            if( sensor.getDistance_mm()> 400) g=1; //green light on
            else g=0;         //green light off


            if( sensor.getDistance_mm() < 40 )  lcd.print_bm(bitmTank,80,0); //full tank
            lcd.copy_to_lcd();
            if( sensor.getDistance_mm() > 80 )  lcd.print_bm(bitmNinetyTank,80,0); //90% full tank
            lcd.copy_to_lcd();
            if( sensor.getDistance_mm() > 120  )  lcd.print_bm(bitmEightyTank,80,0); //80% full tank
            lcd.copy_to_lcd();
            if( sensor.getDistance_mm() > 160 )  lcd.print_bm(bitmSeventyTank,80,0); //70% full tank
            lcd.copy_to_lcd();
            if( sensor.getDistance_mm() > 200 )  lcd.print_bm(bitmSixtyTank,80,0); //60% full tank
            lcd.copy_to_lcd();
            if( sensor.getDistance_mm() > 240 )  lcd.print_bm(bitmFiftyTank,80,0); //50% full tank
            lcd.copy_to_lcd();
            if( sensor.getDistance_mm() > 280 )  lcd.print_bm(bitmFourtyTank,80,0); //40% full tank
            lcd.copy_to_lcd();
            if( sensor.getDistance_mm() > 320 )  lcd.print_bm(bitmThirtyTank,80,0); //30% full tank
            lcd.copy_to_lcd();
            if( sensor.getDistance_mm() > 360 )  lcd.print_bm(bitmTwentyTank,80,0); //20% full tank
            lcd.copy_to_lcd();
            if( sensor.getDistance_mm() > 400 )  lcd.print_bm(bitmTenTank,80,0); //10% full tank
            lcd.copy_to_lcd();
            if( sensor.getDistance_mm() > 440 )  lcd.print_bm(bitmEmptyTank,80,0); //empty tank
            lcd.copy_to_lcd();


        }
    }


// https://os.mbed.com/media/uploads/Njbuch/wiley_publishing_-_c_for_dummies_2nd.edition_-2004-.pdf




}

