/*
  Update: 21-06-2010
  The basic authentication service for twitter is going down at the end of the week.
  To continue using that program, the code has been updated to use http://supertweet.net which acts as an API proxy.
  Simply visit the website to setup your twitter account for this API.
  See: http://www.supertweet.net/about/documentation
*/

#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

EthernetNetIf eth; 

int main() {

  printf("Init\n");

  printf("\r\nSetting up...\r\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("\r\nSetup OK\r\n");

  HTTPClient twitter;
  
  HTTPMap msg;
  msg["status"] = "I am tweeting from my mbed!"; //A good example of Key/Value pair use with Web APIs

  twitter.basicAuth("UCLAIEEEOPSLAB", "ilovetwitter"); //We use basic authentication, replace with you account's parameters
  
  //No need to retieve data sent back by the server
  HTTPResult r = twitter.post("http://api.supertweet.net/1/statuses/update.xml", msg, NULL); 
  if( r == HTTP_OK )
  {
    printf("Tweet sent with success!\n");
  }
  else
  {
    printf("Problem during tweeting, return code %d\n", r);
  }
  
  return 0;

}
