#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

AnalogIn proxSensor(p20);
DigitalOut indicator(p22);
Serial pc(USBTX, USBRX);
EthernetNetIf eth; 

int main() {
  //int t;
  //pc.printf("Init\n");
  //pc.printf("Please set the current time.");
  //pc.scanf("%d", &t);
  set_time(1327678449);

  printf("\r\nSetting up...\r\n");
  for (int i = 0; i < 5; i++)
  {
    indicator = 1;
    wait(0.25);
    indicator = 0;
    wait(0.25);
  }
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("\r\nSetup OK\r\n");

  HTTPClient twitter;
  HTTPMap msg;
  float thresh = 0.2;
  int op = 0;
  int cl = 0;
  bool open = false;
  bool initial = true;
  float curr_val = proxSensor;
  
  msg["status"] = "Lab occupancy sensor online!"; 
  twitter.basicAuth("UCLAIEEEOPSLAB", "ilovetwitter");       
  HTTPResult r = twitter.post("http://api.supertweet.net/1/statuses/update.xml", msg, NULL); 
  
  while (true) {
    time_t seconds = time(NULL);
      
    if ((curr_val = proxSensor) > thresh){
       op++;
       cl = 0;
    }
       
    else {
       cl++;
       op = 0;
    }
    
    if (op > 20 && (!open || initial))
    {
       char buffer[64];
       strftime(buffer, 64, "The lab is open as of %I:%M %p!\n", localtime(&seconds));
       pc.printf("%s", buffer);
       msg["status"] = buffer; //A good example of Key/Value pair use with Web APIs
       open = true;
       initial = false;
       op = 0;
       cl = 0;
       indicator = 1;

       twitter.basicAuth("UCLAIEEEOPSLAB", "ilovetwitter"); //We use basic authentication, replace with you account's parameters       
       HTTPResult r = twitter.post("http://api.supertweet.net/1/statuses/update.xml", msg, NULL); 
       if( r == HTTP_OK )
         printf("Tweet sent with success!\n");
 
       else
         printf("Problem during tweeting, return code %d\n", r);
    }
    
    if (cl > 20 && (open || initial))
    {
       char buffer[64];
       strftime(buffer, 64, "The lab is closed as of %I:%M %p.\n", localtime(&seconds));
       pc.printf("%s", buffer);
       msg["status"] = buffer; //A good example of Key/Value pair use with Web APIs
       
       open = false;
       initial = false;
       op = 0;
       cl = 0;
       indicator = 0;

       twitter.basicAuth("UCLAIEEEOPSLAB", "ilovetwitter"); //We use basic authentication, replace with you account's parameters
       HTTPResult r = twitter.post("http://api.supertweet.net/1/statuses/update.xml", msg, NULL); 
       if( r == HTTP_OK )
         printf("Tweet sent with success!\n");
 
       else
         printf("Problem during tweeting, return code %d\n", r);
    }
    
    pc.printf("Current reading: %f\n", curr_val); 
    wait(0.5);
  }
}