#include "QEI.h"
#include "MODSERIAL.h"
#include "stdio.h" //sscanf
#include "mbed.h"
#include "math.h" // abs

// Serial communications with Matlab, to control the robot and make a design.
// Communications sent:
// %i; Pulses sent, followed by a \r\n;
// This will be sent on every call of MatlabComm.
// In case of data, MatlabComm will read the Serial input buffer until it is empty, or until it has read a number

class MatlabComm {
    public: 
        MatlabComm(PinName MotorDirectionPin, PinName MotorSpeedPin, PinName EncoderChannelA, PinName EncoderChannelB);
        void Step();
    private: 
        PwmOut M_SpeedPin;
        DigitalOut M_DirectionPin;
        QEI M_Encoder;
        MODSERIAL pc;
        void read();
        void write();
        void flush_buffer();
        static const int buffer_max_index=29;
        char char_buffer[30];
        int buffer_index;
    };