// header
#include "mbed.h"
#include "lib_TagType4.h"
#include "lib_NDEF.h"
#include "I2C.h"
#define MAXMEMORY 8190 //Max Memory of NFC01A1
#define BITSIZE MAXMEMORY


Serial pc(SERIAL_TX, SERIAL_RX); // define serial bus
 
DigitalOut myled(LED1);
//various LEDs on NFC Shield
DigitalOut nfcled1(D5);
DigitalOut nfcled2(D4);
DigitalOut nfcled3(D2);
//acknowledgement pins

DigitalIn NFC_Written(D12);

int main() {
    // Create NDEF buffer
    uint8_t NDEF_Buffer[BITSIZE], Zero_Buffer[MAXMEMORY];
    memset(NDEF_Buffer, 0, sizeof(NDEF_Buffer));
    memset(Zero_Buffer, 0, sizeof(Zero_Buffer)); // will not change
    
    // start up info... the following code is necessary to read the NFC shield
    sCCFileInfo CCFileStruct;
    sCCFileInfo *pCCFile;
    pCCFile = &CCFileStruct;

    uint16_t status = SUCCESS;
    uint8_t CCBuffer[15];
    
    status = TagT4Init( CCBuffer, sizeof(CCBuffer));
    
    if( status == SUCCESS)
    {   
        pCCFile->NumberCCByte = (uint16_t) ((CCBuffer[0x00]<<8) | CCBuffer[0x01]);
        pCCFile->Version = CCBuffer[0x02];
        pCCFile->MaxReadByte = (uint16_t) ((CCBuffer[0x03]<<8) | CCBuffer[0x04]);
        pCCFile->MaxWriteByte = (uint16_t) ((CCBuffer[0x05]<<8) | CCBuffer[0x06]);
        pCCFile->TField = CCBuffer[0x07];
        pCCFile->LField = CCBuffer[0x08];
        pCCFile->FileID = (uint16_t) ((CCBuffer[0x09]<<8) | CCBuffer[0x0A]);
        pCCFile->NDEFFileMaxSize = (uint16_t) ((CCBuffer[0x0B]<<8) | CCBuffer[0x0C]);
        pCCFile->ReadAccess = CCBuffer[0x0D];
        pCCFile->WriteAccess = CCBuffer[0x0E];  
    }
    
    // open NDEF session 
    OpenNDEFSession(pCCFile->FileID, ASK_FOR_SESSION);
    
    // write all zeros to NDEF memory
    NDEF_WriteNDEF(Zero_Buffer);
    
    // close NDEF session
    CloseNDEFSession(pCCFile->FileID);
    
    // creat while loop
    
    pc.printf("init \n");
    while(1) {
        if (NFC_Written==0) {
            pc.printf("session\n");
            wait(4);
            //open NDEF session
            OpenNDEFSession(pCCFile->FileID, ASK_FOR_SESSION);
            
            // read NDEF
            NDEF_ReadNDEF(NDEF_Buffer);
            
            // close NDEF session
            CloseNDEFSession(pCCFile->FileID);
                 
            
            // if NDEF is not all 0s, take the store memory in variable
            if ((memcmp(Zero_Buffer, NDEF_Buffer, sizeof(NDEF_Buffer)))!=0){ 
        
                pc.printf("Tag Identified...\nContents: \n");
                
                
                //for loop to print memory...
                for (int c=0; c<BITSIZE; c++)
                    pc.printf("%c",NDEF_Buffer[c]);
                
                // write all 0s to the NFC memory
                OpenNDEFSession(pCCFile->FileID, ASK_FOR_SESSION);
                NDEF_WriteNDEF(Zero_Buffer); 
                CloseNDEFSession(pCCFile->FileID);
                memset(NDEF_Buffer, 0, sizeof(NDEF_Buffer));
            }
        }
    }
}