#ifndef _QUADSPI_H_
#define _QUADSPI_H_

#include "mbed.h"

class QuadSPI: SPI {

public:

    /** Create a QuadSPI master connected to the specified pins
     *
     *  mosi or miso can be specfied as NC if not used
     *
     *  @param mosi QuadSPI Master Out, Slave In pin
     *  @param miso QuadSPI Master In, Slave Out pin
     *  @param sclk QuadSPI Clock pin
     *  @param ssel QuadSPI chip select pin
     */
	QuadSPI(PinName mosi, PinName miso, PinName sclk, PinName ssel=NC);

    /** Write to the Quad SPI Slave and return the response
     *
     *  @param value Data to be sent to the SPI slave
     *
     *  @returns
     *    none
    */
    int write(int value);

    /** Read from the Quad SPI Slave and return the response
     *
     *  @param none
     *
     *  @returns
     *    Response from the SPI slave
    */
    int read();

};

#endif /* _QUADSPI_H_ */

