#include "mbed.h"
#include "TMP36.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "PinDetect.h"
#include "Speaker.h"
#include "Shiftbrite.h"
#include <math.h>
#include <iostream>
#include "stdio.h"

// use class to setup temperature sensor pins
TMP36 myTMP36(p15);  //Analog in

// use class to setup microSD card filesystem
SDFileSystem sd(p5, p6, p7, p8, "sd");

// use class to setup the  Color LCD
uLCD_4DGL uLCD(p28, p27, p29); // create a global uLCD object

// use class to setup pushbuttons pins
PinDetect pb1(p23);
PinDetect pb2(p24);
PinDetect pb3(p25);
PinDetect pb4(p26);

// use class to setup speaker pin
Speaker mySpeaker(p21); //PWM out

// use class to setup Shiftbrite pins
Shiftbrite myShiftbrite(p9, p10, p11, p12, p13);// ei li di n/c ci

// use class to setup Mbed's four on-board LEDs
DigitalOut myLED1(LED1);
DigitalOut myLED2(LED2);
DigitalOut myLED3(LED3);
DigitalOut myLED4(LED4);

//also setting any unused analog input pins to digital outputs reduces A/D noise a bit
//see http://mbed.org/users/chris/notebook/Getting-best-ADC-performance/
DigitalOut P16(p16);
DigitalOut P17(p17);
DigitalOut bluepin(p18);
DigitalOut greenpin(p19);
DigitalOut redpin(p20);

// Global variables used in callbacks and main program
// C variables in interrupt routines should use volatile keyword
//int volatile heat_setting=78; // heat to temp
//int volatile cool_setting=68; // cool to temp
//bool volatile mode=false; // heat or cool mode
int target_temp;
int Prior_temp = 75;
double tempF = 75;
int volatile heat_setpoint = 77;
int volatile cool_setpoint = 68;
int volatile heat_setpoint_C = 25;
int volatile cool_setpoint_C = 20;
int mode = 0;
int centigrade = 0;

// Callback routine is interrupt activated by a debounced pb1 hit
void pb1_hit_callback (void)
{
    target_temp++;
    mySpeaker.PlayNote(2000.0, 0.05, 1.0);
}
// Callback routine is interrupt activated by a debounced pb2 hit
void pb2_hit_callback (void)
{
    target_temp--;
    mySpeaker.PlayNote(2000.0, 0.05, 1.0);
}
// Callback routine is interrupt activated by a debounced pb3 hit
void pb3_hit_callback (void)
{
    mode =  (mode + 1) % 3; // Cycle forward  by 1
    mySpeaker.PlayNote(3000.0, 0.025, 1.0);
}
void pb4_hit_callback (void)
{
    wait(.001);
    centigrade = (centigrade + 1) % 2;
}

int main()
{
    float Current_temp=0.0;

    // Use internal pullups for the three pushbuttons
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.01);
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);
    pb4.attach_deasserted(&pb4_hit_callback);
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    pb4.setSampleFrequency();
    // pushbuttons now setup and running
    
    printf("Hello PC World\n\r"); // need terminal application running on PC to see this output
    uLCD.printf("\n\rJoe's Thermostat\n\r"); // LCD
    mySpeaker.PlayNote(500.0, 1.0, 1.0); // Speaker buzz
    enum Statetype { Off = 0, Heat_off, Heat_on, Cool_off, Cool_on };
    Statetype state = Off;
    uLCD.locate(3,6);
    uLCD.printf("OFF         ");
    // State machine code below will need changes and additions
    while (1) {
            
        while(1) {
            Prior_temp = tempF;
            Current_temp = myTMP36; //Read temp sensor
            tempF = (9.0*Current_temp)/5.0+ 32.0;
            double tempC = Current_temp;
            
            
            switch (mode) {
            case (0):
                uLCD.locate(3,6);
                uLCD.printf("OFF         ");
                //target_temp = 75;
                break;
            case (1):
                uLCD.locate(3,6);
                uLCD.color(RED);
                uLCD.printf("HEAT        ");
                uLCD.color(GREEN);
                //if (centigrade == 0)
                  //  target_temp = heat_setpoint;
                //else
                  //  target_temp = heat_setpoint_C;
                break;
            case (2):
                uLCD.locate(3,6);
                uLCD.color(LBLUE);
                uLCD.printf("COOL        ");
                uLCD.color(GREEN);
               // if (centigrade == 0)
                 //   target_temp = cool_setpoint;
                //else
                  //  target_temp = cool_setpoint_C;
                break;
            }
            
            
            
            if (centigrade == 1)
                tempF = tempC;
            //tempF = round(tempF);
            
            uLCD.locate(2,10);
            if (centigrade == 0)
            {
                uLCD.text_width(2);
                uLCD.text_height(2);
                uLCD.printf("%5.0F F \n\r", tempF);  
                uLCD.text_width(1);
                uLCD.text_height(1);
            }
            if (centigrade == 1)
            {
                uLCD.text_width(2);
                uLCD.text_height(2);
                uLCD.printf("%5.0F C \n\r", tempC);
                uLCD.text_width(1);
                uLCD.text_height(1);
            }
                
            if (mode == 0)
            {
                state = Off;
                greenpin = 1;
                redpin = 0;
                bluepin = 0;
            }
            if (mode == 1)
            {
                if (tempF > target_temp + 1)
                    {
                        if (Prior_temp < target_temp + 1)
                        {
                            mySpeaker.PlayNote(500.0, 0.025, 1.0);
                        }
                        greenpin = 0;
                        redpin = 0;
                        bluepin = 0;
                        state = Heat_off;
                    }
                if (tempF < target_temp - 1)
                    {
                        if (Prior_temp > target_temp - 1)
                        {
                            mySpeaker.PlayNote(500.0, 0.025, 1.0);
                        }
                        greenpin = 0;
                        redpin = 1;
                        bluepin = 0;
                        state = Heat_on;
                    }
            }
            if (mode == 2)
            {
                if (tempF > target_temp + 1)
                    {
                        if (Prior_temp < target_temp + 1)
                        {
                            mySpeaker.PlayNote(1000.0, 0.025, 1.0);
                        }
                        greenpin = 0;
                        redpin = 0;
                        bluepin = 1;
                        state = Cool_on;
                    }
                if (tempF < target_temp - 1)
                    {
                        if (Prior_temp > target_temp - 1)
                        {
                            mySpeaker.PlayNote(1000.0, 0.025, 1.0);
                        }
                        greenpin = 0;
                        redpin = 0;
                        bluepin = 0;
                        state = Cool_off;
                    }
            }
            uLCD.locate(3,5);
            if (mode == 1) {
                uLCD.color(RED);
                uLCD.printf("Heat to: %2d", target_temp);
                uLCD.color(GREEN);
                myLED1 = 1;
                myLED2 = 0; }
            if (mode == 2) {
                uLCD.color(LBLUE);
                uLCD.printf("Cool to: %2d", target_temp);
                uLCD.color(GREEN);
                myLED1 = 0;
                myLED2 = 1; }
            if (mode == 0) {
                uLCD.printf("                ", target_temp);
                myLED1 = 0;
                myLED2 = 0; }
                
                switch (state) {
                    case Heat_off:
                        myLED3 = 0;
                        myLED4 = 0;
                        //state = Heat_on;
                        uLCD.locate(3,4);
                        uLCD.printf("Heat Off");
                        break;
                    case Heat_on:
                        myLED3 = 0;
                        myLED4 = 1;
                        //state = Heat_off;
                        uLCD.locate(3,4);
                        uLCD.color(RED);
                        uLCD.printf("Heat On  ");
                        uLCD.color(GREEN);
                        break;
                    case Cool_off:
                        myLED3 = 0;
                        myLED4 = 0;
                        //state = Cool_on;
                        uLCD.locate(3,4);
                        uLCD.printf("Cool Off");
                        break;
                    case Cool_on:
                        myLED3 = 1;
                        myLED4 = 0;
                        //state = Cool_off;
                        uLCD.locate(3,4);
                        uLCD.color(LBLUE);
                        uLCD.printf("Cool On  ");
                        uLCD.color(GREEN);
                        break;
                    case Off:
                        myLED4 = 0;
                        uLCD.locate(3,4);
                        uLCD.printf("         ");
                        break;
                }
        
                wait(0.33);
        }
    }
}