extern uLCD_4DGL uLCD;
extern Mutex mutex;
extern DigitalOut myled1;

struct ObstLocation {
    int x1, y1, x2, y2;
};

class Obstacle
{
    int x1,x2,y1,y2;
    bool direction;

public:
    Obstacle();
    Obstacle(int x1, int y1, int x2, int y2);
    void drawObstacle();
    void eraseObstacle();
    void move(int speed);
    void changeDirection();// need change direction when hitting wall
    void setDirection(bool direction);
    ObstLocation getLocation();
};

Obstacle::Obstacle() {
    x1 = 2;
    x2 = 50;
    y1 = 62;
    y2 = 65;
    direction = 1;
}

Obstacle::Obstacle(int a, int b, int c, int d) {
    x1 = a;
    y1 = b;
    x2 = c;
    y2 = d;
}

void Obstacle::drawObstacle() {
    mutex.lock();
    uLCD.filled_rectangle(x1,y1,x2,y2,DGREY);
    mutex.unlock();

}

void Obstacle::eraseObstacle() {
    mutex.lock();
    uLCD.filled_rectangle(x1,y1,x2,y2,BACKGROUND);
    mutex.unlock();

}

void Obstacle::move(int speed) {
    mutex.lock();
    Obstacle::eraseObstacle();
    if ((x1<=1 && direction==0) || (x2>=127 && direction==1)) {
        Obstacle::changeDirection();
    }
    if (direction==1) {
        x1 += speed;
        x2 += speed;
    }
    else {
        x1 -= speed;
        x2 -= speed;
    }
    Obstacle::drawObstacle();
    mutex.unlock();
}

void Obstacle::changeDirection() {
    direction = !direction;
}

void Obstacle::setDirection(bool a) {
    direction = a;
}

ObstLocation Obstacle::getLocation() {
    ObstLocation coor {x1, y1, x2, y2};
    return coor;
}