extern uLCD_4DGL uLCD;
extern Mutex mutex;

struct BulletLocation {
    int x, topY, bottomY;   
};

class Bullet {
    
        int x, topY, bottomY;
        int length;
        int speed;
        
        
    public:   
        Bullet();
        void drawBullet(int x, int bottomY);
        void eraseBullet();
        void move();   
        BulletLocation getLocation();         
};

Bullet::Bullet() {
    length = 3;
    speed = 3;
    x=1;
    topY=2;
    bottomY=3;
}

void Bullet::drawBullet(int x2, int bottomY2) {
    x = x2;
    bottomY = bottomY2;
    topY = bottomY + length;
    mutex.lock();
    uLCD.line(x,topY,x,bottomY, BLACK);
    mutex.unlock();

}

void Bullet::move() {
    Bullet::eraseBullet();
    bottomY -= speed;
    Bullet::drawBullet(x, bottomY);
}

void Bullet::eraseBullet() {
    mutex.lock();
    uLCD.line(x,topY,x,bottomY, BACKGROUND);
    mutex.unlock();

}

BulletLocation Bullet::getLocation() {
    BulletLocation coor {x, topY, bottomY};
    return coor;
}
