extern uLCD_4DGL uLCD;
extern Mutex mutex;
extern wave_player waver;

class Shooter
{
    int x;

public:
    Shooter();
    void drawShooter();
    void eraseShooter();
    void moveLeft();
    void moveRight();
    int getLocation();
};

Shooter::Shooter() {
    x = 64;
}

void Shooter::drawShooter() {
    mutex.lock();
    uLCD.triangle(x, 115, x-5, 125, x+5, 125, BLUE);
    uLCD.triangle(x, 118, x-2, 123, x+2, 123, BLUE);
    mutex.unlock();
}

void Shooter::eraseShooter() {
    mutex.lock();
    uLCD.filled_rectangle(0, 115, 127, 127, BACKGROUND);
    mutex.unlock();
}

void Shooter::moveLeft() {
    if (x==24) return;
    mutex.lock();
    Shooter::eraseShooter();
    if (x==64) x = 24;
    if (x==104) x = 64;
    Shooter::drawShooter();
    mutex.unlock();
    
    FILE *wave_file;
    wave_file=fopen("/sd/wavfiles/move.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
}

void Shooter::moveRight() {
    if (x==104) return;
    mutex.lock();
    Shooter::eraseShooter();
    if (x==64) x = 104;
    if (x==24) x = 64;
    Shooter::drawShooter();
    mutex.unlock();
    
    FILE *wave_file;
    wave_file=fopen("/sd/wavfiles/move.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
}  

int Shooter::getLocation() {
    return x;
}