#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"

/* shiftbright instantiation*/
PwmOut red(p21);
PwmOut blue(p23);
PwmOut green(p22);

/*uLCD instantiation*/
uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
Mutex mutex;

/* wave player instantiation*/
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
AnalogOut DACout(p18);
wave_player waver(&DACout);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led4(LED4);

/* makes different colored squares the same color as the shiftbright*/
void lcd_thread1(void const *args) {
    int dist = 40;
    while (true) {
        if (red != 0) {
        mutex.lock();
        //uLCD.cls();
        //uLCD.filled_rectangle(64-25, 64-25, 64+25, 64+25, 0xff66cc);
        uLCD.cls();
        uLCD.locate(64,64);
        uLCD.color(0xFFFF00); //yellow text
        uLCD.background_color(0xFFA500); //orange
        uLCD.filled_rectangle(64-dist, 64-dist, 64+dist, 64+dist, 0xff0000); //red square
        uLCD.text_mode(OPAQUE);
        uLCD.printf("Charmander!!");
        mutex.unlock();
        //Thread::wait(1000);
        }
    }
}

/*makes different colored circle every time the bell sound sounds*/
void lcd_thread2(void const *args) {
    int rad = 40;
    while (true) {
        if (blue == 1) {
        mutex.lock();
        uLCD.cls();
        uLCD.locate(64,64);
        uLCD.color(0xFFFF00); //yellow text
        uLCD.background_color(0x0000ff); //blue background
        uLCD.filled_circle(64, 64, rad, 0xB7D5E9); //light blue circle
        uLCD.text_mode(OPAQUE);
        uLCD.printf("Bulbasaur!!");
        //uLCD.filled_rectangle(64-25, 64-25, 64+25, 64+25, 0x336600);
        mutex.unlock();
        }
    }
}

/*play wav file on sd and when playing led1 turns on*/
void wav_thread3(void const *args) {
    while (1) {
        FILE *wave_file;
        wave_file=fopen("/sd/wavfiles/alarm.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
    }
}

void light_thread4(void const *args) {
    while (true) {
        red = 0;
        blue = 1;
        green = 0;
    
        Thread::wait(1000);  
    
        red = 0.8;
        blue = 0;
        green = 0;

        Thread::wait(1000);   
    }
}
 
int main() {
    Thread thread1(lcd_thread1);
    Thread thread2(lcd_thread2);
    Thread thread3(wav_thread3);
    Thread thread4(light_thread4);
    while(1);
}
