#include "mbed.h"

DigitalOut myled(LED1);

#include <stdbool.h>
#include <stdint.h>
#include <string.h>
//#include "nrf.h"
#include "micro_esb.h"
#include "uesb_error_codes.h"
#include "nrf_delay.h"
//#include "nrf_gpio.h"

static uesb_payload_t tx_payload, rx_payload;

class Micro_esb {
    
    uesb_mainstate_t         m_uesb_mainstate;
    
    uesb_config_t            m_config_local;
    
    uesb_payload_tx_fifo_t   m_tx_fifo;
    uesb_payload_rx_fifo_t   m_rx_fifo;
    
    uint32_t  m_interrupt_flags;
    uint32_t  m_last_tx_attempts;
    
    public:
    
    uint32_t uesb_set_address(uesb_address_type_t address, const uint8_t *data_ptr)
    {
        if(m_uesb_mainstate != UESB_STATE_IDLE) return UESB_ERROR_NOT_IDLE;
        switch(address) {
            case UESB_ADDRESS_PIPE0:
                memcpy(m_config_local.rx_address_p0, data_ptr, m_config_local.rf_addr_length);
                break;
            case UESB_ADDRESS_PIPE1:
                memcpy(m_config_local.rx_address_p1, data_ptr, m_config_local.rf_addr_length);
                break;
            case UESB_ADDRESS_PIPE2:
                m_config_local.rx_address_p2 = *data_ptr;
                break;
            case UESB_ADDRESS_PIPE3:
                m_config_local.rx_address_p3 = *data_ptr;
                break;
            case UESB_ADDRESS_PIPE4:
                m_config_local.rx_address_p4 = *data_ptr;
                break;
            case UESB_ADDRESS_PIPE5:
                m_config_local.rx_address_p5 = *data_ptr;
                break;
            case UESB_ADDRESS_PIPE6:
                m_config_local.rx_address_p6 = *data_ptr;
                break;
            case UESB_ADDRESS_PIPE7:
                m_config_local.rx_address_p7 = *data_ptr;
                break;
            default:
                return UESB_ERROR_INVALID_PARAMETERS;
        }
        //update_radio_parameters();
        return UESB_SUCCESS;
    }
    
    uint32_t uesb_flush_tx(void)
    {
        if(m_uesb_mainstate != UESB_STATE_IDLE) return UESB_ERROR_NOT_IDLE;
        DISABLE_RF_IRQ;
        m_tx_fifo.count = 0;
        m_tx_fifo.entry_point = m_tx_fifo.exit_point = 0;
        ENABLE_RF_IRQ;
        return UESB_SUCCESS;
    }
    
    uint32_t uesb_get_tx_attempts(uint32_t *attempts)
    {
        if(m_uesb_mainstate == UESB_STATE_UNINITIALIZED) return UESB_ERROR_NOT_INITIALIZED;
        *attempts = m_last_tx_attempts;
        return UESB_SUCCESS;
    }
    
    uint32_t uesb_read_rx_payload(uesb_payload_t *payload)
    {
        if(m_uesb_mainstate == UESB_STATE_UNINITIALIZED) return UESB_ERROR_NOT_INITIALIZED;
        if(m_rx_fifo.count == 0) return UESB_ERROR_RX_FIFO_EMPTY;
    
        DISABLE_RF_IRQ;
        payload->length = m_rx_fifo.payload_ptr[m_rx_fifo.exit_point]->length;
        payload->pipe   = m_rx_fifo.payload_ptr[m_rx_fifo.exit_point]->pipe;
        payload->rssi   = m_rx_fifo.payload_ptr[m_rx_fifo.exit_point]->rssi;
        memcpy(payload->data, m_rx_fifo.payload_ptr[m_rx_fifo.exit_point]->data, payload->length);
        if(++m_rx_fifo.exit_point >= UESB_CORE_RX_FIFO_SIZE) m_rx_fifo.exit_point = 0;
        m_rx_fifo.count--;
        ENABLE_RF_IRQ;
    
        return UESB_SUCCESS;
    }
    
    uint32_t uesb_get_clear_interrupts(uint32_t *interrupts)
    {
        DISABLE_RF_IRQ;
        *interrupts = m_interrupt_flags;
        m_interrupt_flags = 0;
        ENABLE_RF_IRQ;
        return UESB_SUCCESS;
    }
};
    
Micro_esb micro_esb;    
    

void uesb_event_handler()
{
    static uint32_t rf_interrupts;
    static uint32_t tx_attempts;
    
    micro_esb.uesb_get_clear_interrupts(&rf_interrupts);
    
    if(rf_interrupts & UESB_INT_TX_SUCCESS_MSK)
    {   
    }
    
    if(rf_interrupts & UESB_INT_TX_FAILED_MSK)
    {
        micro_esb.uesb_flush_tx();
    }
    
    if(rf_interrupts & UESB_INT_RX_DR_MSK)
    {
        micro_esb.uesb_read_rx_payload(&rx_payload);
        NRF_GPIO->OUTCLR = 0xFUL << 8;
        NRF_GPIO->OUTSET = (uint32_t)((rx_payload.data[2] & 0x0F) << 8);
    }
    
    micro_esb.uesb_get_tx_attempts(&tx_attempts);
    NRF_GPIO->OUTCLR = 0xFUL << 12;
    NRF_GPIO->OUTSET = (tx_attempts & 0x0F) << 12;
}

int main(void)
{
    uint8_t rx_addr_p0[] = {0x12, 0x34, 0x56, 0x78, 0x9A};
    uint8_t rx_addr_p1[] = {0xBC, 0xDE, 0xF0, 0x12, 0x23};
    uint8_t rx_addr_p2   = 0x66;
    
    //nrf_gpio_range_cfg_output(8, 15);
    
    uesb_mainstate_t  m_uesb_mainstate = UESB_STATE_UNINITIALIZED;
    
    //m_interrupt_flags = 0;
    
    NRF_CLOCK->EVENTS_HFCLKSTARTED = 0;
    NRF_CLOCK->TASKS_HFCLKSTART = 1;
    while(NRF_CLOCK->EVENTS_HFCLKSTARTED == 0);

    uesb_config_t uesb_config       = UESB_DEFAULT_CONFIG;
    uesb_config.rf_channel          = 5;
    uesb_config.crc                 = UESB_CRC_16BIT;
    uesb_config.retransmit_count    = 6;
    uesb_config.retransmit_delay    = 500;
    uesb_config.dynamic_ack_enabled = 0;
    uesb_config.protocol            = UESB_PROTOCOL_ESB_DPL;
    uesb_config.bitrate             = UESB_BITRATE_2MBPS;
    uesb_config.event_handler       = uesb_event_handler;
    
    //uesb_init(&uesb_config);

    micro_esb.uesb_set_address(UESB_ADDRESS_PIPE0, rx_addr_p0);
    micro_esb.uesb_set_address(UESB_ADDRESS_PIPE1, rx_addr_p1);
    micro_esb.uesb_set_address(UESB_ADDRESS_PIPE2, &rx_addr_p2);

    tx_payload.length  = 8;
    tx_payload.pipe    = 0;
    tx_payload.data[0] = 0x01;
    tx_payload.data[1] = 0x00;
    tx_payload.data[2] = 0x00;
    tx_payload.data[3] = 0x00;
    tx_payload.data[4] = 0x11;
    
    while (true)
    {   
        //if(uesb_write_tx_payload(&tx_payload) == UESB_SUCCESS)
        //{
        //    tx_payload.data[1]++;
        //}
        nrf_delay_us(10000);
    }
}

