#include "mbed.h"
#include "nRF24L01P.h"

Serial pc(USBTX, USBRX); // tx, rx

/* this is being used with the nucleo F401RE */

nRF24L01P my_nrf24l01p(PB_5, PB_4, PB_3, PA_4, PC_1 , PC_0);    // mosi, miso, sck, csn, ce, irq
/*
*  SPI_MOSI    = PB5, //previously PE_15, 
*  SPI_MISO    = PB4, // previously PE_14, 
*  SPI_SCK     = PB3, // previously PE_13, 
*  SPI_CS      = PA4, // previously PE_12, 
*  CE = PC1, // previously PE_10 
*  IRQ = PC0 , // previously PE_11 
*/


DigitalOut myled1(LED1);
DigitalOut myled2(LED2);

void channelChangeMode (void)
{
  // NEEDS fixed to accept two digit number
  #define   RF_CHANNEL_SIZE 2
  
    char stayInWhile = 1;
    char receivedChannelCharacter;
    int rf_channel = 2400;
    int rf_channel_temp = 0;
    char rf_channel_char[RF_CHANNEL_SIZE];
    int rf_channelCnt = 0;
    
    pc.printf("Channel menu\n\r");
    pc.printf("select channel as XX between 01 and 82\n\r");
    while(stayInWhile)
    {
        pc.printf("waiting for Channel\n\r");
         if ( pc.readable() ) 
         {
            receivedChannelCharacter = pc.getc();

            if (receivedChannelCharacter >= '1' && receivedChannelCharacter <= '9') // if received 0 through 9 load transmit buffer
            {
                rf_channel_char[rf_channelCnt++] = pc.getc();

                pc.printf("received a, %d\n\r", (receivedChannelCharacter - '0'));
                
                // If the transmit buffer is full
                if ( rf_channelCnt >= sizeof( RF_CHANNEL_SIZE ) ) 
                {
                    //checkChannelValue();
                    rf_channel_temp = (rf_channel_char[0]-0x30) * 10;
                    rf_channel_temp += (rf_channel_char[1]-0x30);
                    
                    if((rf_channel_temp >= 1) && (rf_channel_temp <= 82))
                    { 
                        pc.printf("received valid number\n\r");
                        pc.printf("new channel, %d\n\r", rf_channel_temp);
                        rf_channel = rf_channel + rf_channel_temp; 
                        pc.printf("new channel, %d\n\r", rf_channel);
                        my_nrf24l01p.setRfFrequency(rf_channel);
                        wait(1);
                        pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
                        stayInWhile = 0; 
                    }
                    else 
                    {
                        pc.printf(" invalid RF channel number\n\r");
                    }
                    
                }
            }
            else if (receivedChannelCharacter == 'q' ) // if received q, exit channel change
            {
                pc.printf("exiting  Channel change mode\n\r");
                stayInWhile = 0; 
            }
            else
            {
                pc.printf(" invalid number\n\r");
            }
        }
        wait(1);
    }
    pc.printf("exiting  Channel change mode\n\r");
    
}

int main() {

// The nRF24L01+ supports transfers from 1 to 32 bytes, but Sparkfun's
//  "Nordic Serial Interface Board" (http://www.sparkfun.com/products/9019)
//  only handles 4 byte transfers in the ATMega code.
#define TRANSFER_SIZE   4

    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    int txDataCnt = 0;
    int rxDataCnt = 0;
    char receivedTerminalCharacter;

    my_nrf24l01p.powerUp();

    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setAirDataRate(NRF24L01P_DATARATE_250_KBPS);
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );

    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();

    while (1) {

        // If we've received anything over the host serial link...
        if ( pc.readable() ) 
        {

            receivedTerminalCharacter = pc.getc();
            
            if (receivedTerminalCharacter >= '0' && receivedTerminalCharacter <= '9') // if received 0 through 9 load transmit buffer
            {    // ...add it to the transmit buffer
                txData[txDataCnt++] = pc.getc();

                // If the transmit buffer is full
                if ( txDataCnt >= sizeof( txData ) ) 
                {
    
                    // Send the transmitbuffer via the nRF24L01+
                    my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
    
                    txDataCnt = 0;
                }

                // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
                myled1 = !myled1;
            } 
            else if ((receivedTerminalCharacter == 'h') || (receivedTerminalCharacter == 'H')) 
            {
                pc.printf("Radio help menu\n\r");
                pc.printf("Press c for channel: \n\r");
                pc.printf("Press t for TX Power: \n\r");
                pc.printf("Press d for datarate: \n\r");
            } 
            else if (receivedTerminalCharacter == 'c') 
            {
    
                channelChangeMode();
            }
        }

        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable() ) {

            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );

            // Display the receive buffer contents via the host serial link
            for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {

                pc.putc( rxData[i] );
            }

            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            myled2 = !myled2;
        }
    }
}
