#include "mbed.h"

PwmOut mypwm(PWM_OUT);

DigitalOut myled(LED1);

#define UP 1
#define DOWN 2

int main() {
    
    uint8_t i; 
    uint8_t count_dir;
    
    
    mypwm.period_ms(10);
    mypwm.pulsewidth_ms(1);
  
    printf("pwm set to %.2f %%\n", mypwm.read() * 100);
    
    count_dir = UP;
    while(1) {
        myled = !myled;
        for(i = 0; i < 10; i++ )
        {
            wait(0.1);
            if(count_dir == UP)
            {
                mypwm = mypwm + 0.01;
                if(mypwm == 1.00) // if hit one, start counting down
                {
                    count_dir = DOWN;
                }
            }
            else if(count_dir == DOWN)
            {
                mypwm = mypwm - 0.01;
                if(mypwm == 0.0)    // if hit zero, start counting up
                {
                    count_dir = UP;
                }
            }
            
        }
        printf("pwm set to %.2f %%\n\r", mypwm.read() * 100);
    }
}
