#include "mbed.h"
#include "LCD_DISCO_L476VG.h"

LCD_DISCO_L476VG lcd;

#define USE_PRINTF (1)

// Joystick button
InterruptIn center(JOYSTICK_CENTER);
InterruptIn left(JOYSTICK_LEFT);
InterruptIn right(JOYSTICK_RIGHT);
InterruptIn up(JOYSTICK_UP);
InterruptIn down(JOYSTICK_DOWN);

// LEDs
DigitalOut led_green(LED1);
DigitalOut led_red(LED2);

void center_released() {
    led_green = 0;
    lcd.Clear();
#if USE_PRINTF == 1
    printf("center button released\n");
#endif  
}

void center_pressed() {
    led_green = 1;
    lcd.DisplayString((uint8_t *)"Center");
#if USE_PRINTF == 1  
    printf("center button pressed\n");
#endif  
}

void left_released() {
    led_green = 0;
    lcd.Clear();
#if USE_PRINTF == 1
    printf("left button released\n");
#endif  
}

void left_pressed() {
    led_green = 1;
    lcd.DisplayString((uint8_t *)"Left");
#if USE_PRINTF == 1  
    printf("left button pressed\n");
#endif  
}

void right_released() {
    led_green = 0;
    lcd.Clear();
#if USE_PRINTF == 1
    printf("right button released\n");
#endif  
}

void right_pressed() {
    led_green = 1;
    lcd.DisplayString((uint8_t *)"Right");
#if USE_PRINTF == 1  
    printf("right button pressed\n");
#endif  
}

void up_released() {
    led_green = 0;
    lcd.Clear();
#if USE_PRINTF == 1
    printf("up button released\n");
#endif  
}

void up_pressed() {
    led_green = 1;
    lcd.DisplayString((uint8_t *)"Up");
#if USE_PRINTF == 1  
    printf("up button pressed\n");
#endif  
}

void down_released() {
    led_green = 0;
    lcd.Clear();
#if USE_PRINTF == 1
    printf("down button released\n");
#endif  
}

void down_pressed() {
    led_green = 1;
    lcd.DisplayString((uint8_t *)"Down");
#if USE_PRINTF == 1  
    printf("down button pressed\n");
#endif  
}

int main()
{
    uint32_t temp = 0;
    uint8_t stemp[7] = {0};
    //uint8_t title[] = "      DISCOVERY STM32L476";
    uint8_t title[] = "      EET Micros 1";
  #if USE_PRINTF == 1  
    int i = 0;
    printf("\nStart!\n");
#endif
  
    // Both rise and fall edges generate an interrupt
    center.fall(&center_released);
    center.rise(&center_pressed);
    left.fall(&left_released);
    left.rise(&left_pressed);
    right.fall(&right_released);
    right.rise(&right_pressed);
    up.fall(&up_released);
    up.rise(&up_pressed);
    down.fall(&down_released);
    down.rise(&down_pressed);

    // Add pull-down on these pins
    // Warning: must be done AFTER edges setting
    left.mode(PullDown);
    right.mode(PullDown);
    up.mode(PullDown);
    down.mode(PullDown);
  
    printf("Hello\n");
    led_green = 1;
    lcd.Clear();
    lcd.DisplayString((uint8_t *)"YSU");
    wait(1);
    
    printf("Scroll sequence\n");
    led_green = 0;
    led_red = 1;
    lcd.Clear();
    lcd.ScrollSentence(title, 2, 200);
    lcd.Clear();
  
    while(1) {
        printf("BAR = %d\n", temp);
        sprintf((char *)stemp, "BAR %d", temp);
        lcd.DisplayString(stemp);
        lcd.BarLevelConfig((uint8_t)temp);
        temp++;
        if (temp > 4) temp = 0;
        led_green = !led_green;
        led_red = !led_red; 
        wait(1);
    }
}
