/* Wiznet W5500 Test Program
 *
 * TCP server(192.168.1.125) is listening with port number 3000 and send back the data to the peer.
 *
 */

#include "mbed.h"
#include "Ethernet/wizchip_conf.h"
#include "Ethernet/socket.h"

SPI spi(p5, p6, p7); // mosi, miso, sclk
DigitalOut cs(p8), nRESET(p9); // reset pin of Wiz550io
DigitalIn RDY(p10);  // ready pin of Wiz550io

Serial pc(USBTX, USBRX); // tx, rx

void  wizchip_select(void);
void  wizchip_deselect(void);
uint8_t wizchip_read();
void  wizchip_write(uint8_t wb);
int32_t loopback_tcps(uint8_t sn, uint8_t* buf, uint16_t size);
int32_t loopback_udps(uint8_t sn, uint8_t* buf, uint16_t size);

#define DATA_BUF_SIZE   2048
uint8_t gDATABUF[DATA_BUF_SIZE];
wiz_NetInfo gWIZNETINFO;

int main()
{
    uint8_t tmp;
    uint8_t tmpstr[6] = {0,};
    int32_t ret = 0;
    uint8_t memsize[2][8] = { {2,2,2,2,2,2,2,2},{2,2,2,2,2,2,2,2}};

    pc.baud(115200);

    spi.format(8,0); // 8bit, mode 0
    spi.frequency(7000000); // 7MHz

	
    nRESET = 0;
    wait(0.001); // 1ms
    nRESET = 1;
    
    cs = 1;
    wait(0.1); // 100ms

    // register the chip select/ deselect fucntion
    reg_wizchip_cs_cbfunc(wizchip_select, wizchip_deselect);

    // register the chip read/ write fucntion
    reg_wizchip_spi_cbfunc(wizchip_read, wizchip_write);

    /* wizchip initialize*/
    if(ctlwizchip(CW_INIT_WIZCHIP,(void*)memsize) == -1) {
        pc.printf("WIZCHIP Initialized fail.\r\n");
        while(1);
    }
    
    do
    {
        if(ctlwizchip(CW_GET_PHYLINK, (void*)&tmp) == -1)
            pc.printf("Unknown PHY Link stauts.\r\n");
    }while(tmp == PHY_LINK_OFF);
    
    /* wizchip netconf */
    ctlnetwork(CN_GET_NETINFO, (void*)&gWIZNETINFO);

    gWIZNETINFO.ip[0] = 192;
    gWIZNETINFO.ip[1] = 168;
    gWIZNETINFO.ip[2] = 1;
    gWIZNETINFO.ip[3] = 125;

    // set network configuration
    ctlnetwork(CN_SET_NETINFO, (void*)&gWIZNETINFO);
    
    // get network configuration
    ctlnetwork(CN_GET_NETINFO, (void*)&gWIZNETINFO);
    
    // Display network configuration
    ctlwizchip(CW_GET_ID,(void*)tmpstr);
    pc.printf("=== %s NET CONF ===\r\n",(char*)tmpstr);
    pc.printf("MAC:%02X.%02X.%02X.%02X.%02X.%02X\r\n",gWIZNETINFO.mac[0],gWIZNETINFO.mac[1],gWIZNETINFO.mac[2],
                                                      gWIZNETINFO.mac[3],gWIZNETINFO.mac[4],gWIZNETINFO.mac[5]);
    pc.printf("GAR:%d.%d.%d.%d\r\n", gWIZNETINFO.gw[0],gWIZNETINFO.gw[1],gWIZNETINFO.gw[2],gWIZNETINFO.gw[3]);
    pc.printf("SUB:%d.%d.%d.%d\r\n", gWIZNETINFO.sn[0],gWIZNETINFO.sn[1],gWIZNETINFO.sn[2],gWIZNETINFO.sn[3]);
    pc.printf("SIP:%d.%d.%d.%d\r\n", gWIZNETINFO.ip[0],gWIZNETINFO.ip[1],gWIZNETINFO.ip[2],gWIZNETINFO.ip[3]);

   while(1)
   {
      uint8_t sn = 2;
      if((ret = socket(sn,Sn_MR_TCP,3000,SF_TCP_NODELAY)) != sn)
      {
         printf("%d:socket() error:%ld\r\n", sn,ret);
         close(sn);
         continue;
      }
      printf("%d:socket() ok.\r\n",sn);
      
      
      if((ret = listen(sn)) != SOCK_OK)
      {
         printf("%d:listen() error:%ld",sn,ret);
         close(sn);
         return ret;
      }
      printf("%d:listen() ok.\r\n",sn);
      
      
      if(((ret = socket(sn+1, Sn_MR_UDP, 3000, 0)) != sn+1))
      {
         printf("%d:socket() error:%ld\r\n", sn+1,ret);
         continue;
      }      
      do
      {
         getsockopt(sn,SO_STATUS, &tmp);
      }while(tmp != SOCK_CLOSED && tmp != SOCK_ESTABLISHED);
      if(tmp == SOCK_CLOSED) continue;
      //Accept for client
      printf("%d:connected\r\nLBStarted Blocking mode\r\n",sn);
      
      while(1)
      {
         if((ret = loopback_tcps(sn, gDATABUF, DATA_BUF_SIZE)) < 0)
         {
            printf("%d:loopback_tcps error:%ld\r\n",sn,ret);
            break;
         }
/*
         if((ret=loopback_udps(sn+1,gDATABUF,10)) < 0)
         {
            printf("%d:loopback_udps error:%ld\r\n",sn+1,ret);
            break;
         }
*/
      }
   }
}

void  wizchip_select(void)
{
    cs = 0;
}

void  wizchip_deselect(void)
{
    cs = 1;
}

uint8_t wizchip_read()
{
    return spi.write(0x00);
}

void  wizchip_write(uint8_t wb)
{
    spi.write(wb);
}

int32_t loopback_tcps(uint8_t sn, uint8_t* buf, uint16_t size)
{
   int32_t ret = 0;
   ret = recv(sn,buf,size);
   if(ret != size)
   {
      if(ret < 0)
      {
         printf("%d:recv() error:%ld\r\n",sn,ret);
         close(sn);
         return ret;
      }
   }
   size = ret;
   ret = send(sn,buf,size);
   if(ret != size)
   {
      if(ret < 0)
      {
         printf("%d:send() error:%ld\r\n",sn,ret);
         close(sn);
      }
   }
   return ret;
}

int32_t loopback_udps(uint8_t sn, uint8_t* buf, uint16_t size)
{
   int32_t  ret = 0;
   static uint8_t  addr[4] = {0,};
   static uint16_t port = 0;
   uint8_t  packinfo;

   if((ret = recvfrom(sn,buf,size, addr,&port,&packinfo)) < 0)
   {
      printf("%d:recvfrom error:%ld\r\n",sn,ret);
      return ret;
   }
   if(packinfo & 0x80)
   {
      printf("%d:recvfrom %d.%d.%d.%d(%d), size=%ld.\r\n",sn,addr[0],addr[1],addr[2],addr[3],port, ret);
   }
   if(packinfo & 0x01)
   {
      printf("%d:recvfrom remained packet.\r\n",sn);
   }
   else
   {
      printf("%d:recvfrom completed.\r\n",sn);
   }
   if( (ret = sendto(sn, buf, ret, addr, port)) < 0)
   {
      printf("%d:sendto error:%ld\r\n",sn,ret);
      return ret;
   }
   printf("%d:sendto %d.%d.%d.%d(%d), size=%ld\r\n",sn,addr[0],addr[1],addr[2],addr[3],port, ret);
   return ret;
}
