//Import libraries
#include "mbed.h"
#include "stdio.h"
#include "math.h"

//Establish serial connection
Serial pc(USBTX, USBRX);
//Create the local filesystem
LocalFileSystem local("local"); 

//Define variables
int N = 50; //Number of samples
float T = 0.1; //Sample period

int main() 
{
    FILE *settings; //Create file with pointer

    settings = fopen("/local/settings.txt", "w");//Open file for writing
    pc.printf("File open.\n"); //Indicates file open
    fprintf(settings, "%i %f", N, T); //Writes settings values onto file
    fclose(settings); //Close file
    pc.printf("Settings saved.\n");
    
    //Define variables for output
    int value1;
    float value2;
    
    settings = fopen("/local/settings.txt" , "r"); //Open file for reading
    fseek(settings, 0 ,SEEK_SET); //Sets cursor to start of file
    fscanf(settings, "%i", &value1);  //Scans for first number
    pc.printf("Settings are:\n");
    pc.printf("%i\n", value1); //Outputs first number
    fseek(settings, sizeof(int), SEEK_SET); //Sets cursor to after first number
    fscanf(settings, "%f", &value2); //Scans for second number
    pc.printf("%f\n", value2); //Outputs second number
    fclose(settings); //Close file
}