//Import libraries
#include "mbed.h"
#include "stdio.h"
#include "math.h"
#include "ADXL362.h"

//Open COM connection
Serial pc(USBTX, USBRX);
//Define accelerometer
ADXL362 adxl362(p11, p12, p13, p10);
//Set up file system
LocalFileSystem local("local");

int N = 50;
float T = 0.1;

int main()
{
    //Initialise accelerometer
    adxl362.init_spi();
    adxl362.init_adxl362();
    wait(0.1);
    
    //Define data variables
    int8_t xdata, ydata, zdata;
    
    //Open data file
    FILE *data;
    data = fopen("/local/data.txt", "w");
    
    //Data collection loop using sample rate and number of samples 
    for(int i=0; i<N; i++)
    {
        //Get accelerometer data
        adxl362.ACC_GetXYZ8(&xdata,&ydata,&zdata);
    
        //Print data to data file
        fprintf(data, "%+04d", xdata);
        fprintf(data, "%+04d", ydata);
        fprintf(data, "%+04d", zdata);
        
        //Attempt to print same data to MATLAB if connection is not null
        if(pc != NULL)
        {
            pc.printf("%+04d\n", xdata);
            pc.printf("%+04d\n", ydata);
            pc.printf("%+04d\n", zdata);
        }
        
        //Pause to ensure sample rate
        wait(T);
    }
    fclose(data);
    
    //Reading section
    
    //Open data file for reading
    data = fopen("/local/data.txt" , "r"); 
    fseek(data, 0 ,SEEK_SET); //Set cursor to start of file 
    int value;
    //Print each piece of data to MATLAB (where it should be put into arrays)
    for(int i=0; i<50; i++)
    {
        fscanf(data, "%d", &value);
        pc.printf("%+04d\n", value);
        fseek(data, sizeof(int), SEEK_CUR); //Sets cursor to next data value
    }
    fclose(data);
}