//Add required libraries
#include "mbed.h"
#include "stdio.h"
#include "math.h"
#include "ADXL362.h"

//Set up serial communication
Serial pc(USBTX, USBRX);
//Set up accelerometer
ADXL362 adxl362(p11, p12, p13, p10);

//Initialise parameters
int N = 50; //Number of samples
float T = 0.1; //Sample period

//Main function
int main()
{
    //Initialise variable used to exit/enter menu
    int exitFlag = 0;
    //Initialise variable to switch between menu options
    int choice;

    //Initialise accelerometer               
    adxl362.init_spi();
    adxl362.init_adxl362();
    wait(0.1);
    
    //Initialise variables to hold accelerometer data
    int8_t xdata, ydata, zdata;
    
    //Enter menu (not visible to user)
    while(exitFlag == 0) //Will repeat this loop until exitflag set to 1 by user (to end program)
    {
        //Scans serial connection for command from MATLAB
        pc.scanf("%i", &choice);
        switch(choice)
        {
            //Switches here if int value 1 is recieved
            case(1):
            {
                //For loop runs data collection N times to ensure correct number of samples
                for(int i=0; i<N; i++)
                {
                    //Gets accelerometer data
                    adxl362.ACC_GetXYZ8(&xdata,&ydata,&zdata);
                    //Sends accelerometer data to MATLAB via serial connection
                    pc.printf("%+04d\n", xdata);
                    pc.printf("%+04d\n", ydata);
                    pc.printf("%+04d\n", zdata);
                    //Waits time T to ensure sample rate
                    wait(T);
                }
            }
            //Switches here if something other than menu options recieved from MATLAB   
            default:
            {
                //Sends error message to MATLAB (will then be relayed to user)
                pc.printf("ERROR");
            }
        }
    }
}

               