//include relevant libraries
#include "mbed.h"
#include "stdio.h"
#include "math.h"
#include "ADXL362.h"

//Define serial connection 
Serial pc(USBTX, USBRX);
//Define accelerometer
ADXL362 adxl362(p11, p12, p13, p10);
//Set up local file system on mbed
LocalFileSystem local("local"); 


//Define paramater strings for communication over USB
char N[100]; //Number of samples
char T [100]; //Sample period 


int main()
{
    
    //Create files with pointers
    FILE *samplesettings; 
    FILE *timesettings;
    
    char res[100];//String to store user command
        
    pc.scanf("%s",res);//Get user command from matlab
   
    while(1)
    {    
        if(!strcmp(res,"1")==0)//If user command is 1 write the sample number settings into a file 
        {  
        
            pc.scanf("%s\n",&N);//Get the number of  samples input by user from the matlab
            samplesettings = fopen("/local/samplesettings.txt", "w");//Open file for writing
            fprintf(samplesettings,"%s\n",N); //Writes settings values onto file
            fclose(samplesettings);//close file
            break;
            
        }
        else if(!strcmp(res,"2")==0)//If user command is 2 display sample number settings
        {
            
            char value1[1000]; //Define variable for output
            samplesettings = fopen("/local/samplesettings.txt" , "r"); //Open file for reading
            fseek(samplesettings, 0 ,SEEK_SET); //Sets cursor to start of file
            fscanf(samplesettings,"%s\n", value1);//Scans fo the value of N
            pc.printf("%s\n", value1);//Prints the value of N
            fclose(samplesettings); //Close file
            break;
            
        }
        else if(!strcmp(res,"3")==0)//If user command recieved is 3 then write the time settings into a file
        {
            
            char T[1000];//To store value of T recieved from matlab
            pc.scanf("%s\n",&T);//To scan value of T from matlab
            timesettings = fopen("/local/timesettings.txt", "w");//Open file for writing
            fprintf(timesettings,"%s\n",T); //Writes settings values onto file                
            fclose(timesettings);//Close file
            break; 
            
        }
        else if(!strcmp(res,"4")==0)//If 4 is recieved as a user command then read the time settings 
        {
            
            //Define variables for output
            char value2[100];
            samplesettings = fopen("/local/timesettings.txt" , "r"); //Open file for reading
            fseek(timesettings, 0 ,SEEK_SET); //Sets cursor to start of file
            fscanf(timesettings,"%s\n", value2);//Reads the time period from the file
            pc.printf("%s\n", value2);//Outsputs the time period 
            fclose(timesettings); //Close file
            break; 
            
        }
        else if(!strcmp(res,"5")==0)//If the user command is 5 then we collect data 
        {
            
            //Initialise accelerometer
            adxl362.init_spi();
            adxl362.init_adxl362();
            wait(0.1);
            
            int8_t xdata, ydata, zdata;
                                        
            //Open data file
            FILE *data;
            data = fopen("/local/data.txt", "w");
        
            //Data collection loop using sample rate and number of samples 
            for(int i=0; i<50; i++)
            {
                
                //Get accelerometer data
                adxl362.ACC_GetXYZ8(&xdata,&ydata,&zdata);
                
                //Print data to data file
                fprintf(data, "%+04d", xdata);
                fprintf(data, "%+04d", ydata);
                fprintf(data, "%+04d", zdata);
                
                //Attempt to print same data to MATLAB if connection is not null
                if(pc != NULL)
                {
                    pc.printf("%+04d\n", xdata);
                    pc.printf("%+04d\n", ydata);
                    pc.printf("%+04d\n", zdata);
                    }
                //Pause to ensure sample rate
                wait(0.1);
                }
                fclose(data);
                break;
                }
            }
        }                                               
         