#pragma once
#ifndef ACCELEROMETER_H
#define ACCELEROMETER_H

#include <processes.h>
#include <Mutexes.h>
#include <channels.h>
#define X_axis p28
#define Y_axis p27

//DigitalOut led3(LED3); //these LEDs are used to indicate when an interrupt occurs.
//DigitalOut led4(LED4);


class accelerometer {
public:
    accelerometer()
            :X_int(X_axis),
             Y_int(Y_axis)
             //X_input(X_axis),
             //Y_input(Y_axis)
     {
            //led3 = led4 = 0;
            X_time = Y_time = 0;
            //enable_flag = false;
            enable_X_rising_flag = enable_X_falling_flag = enable_Y_rising_flag = enable_Y_falling_flag = false;
            X_int.mode(PullDown);
            Y_int.mode(PullDown);
            //Y_input.mode(PullDown);
            //X_input.mode(PullDown);
            X_timer.reset();
            Y_timer.reset();
            set_interrupts();
            enable_X_rising_flag = enable_Y_rising_flag = true;
     }

    
    void set_interrupts()
    {
         X_int.fall(this, &accelerometer::set_X_time);
         X_int.rise(this, &accelerometer::start_X_timing);
         Y_int.fall(this, &accelerometer::set_Y_time);
         Y_int.rise(this, &accelerometer::start_Y_timing);
    }
    
    void start_X_timing() 
    {
         OS::TISRW ISRW;
       if(enable_X_rising_flag == true)
       {
           X_timer.start();
           enable_X_falling_flag = true;
           //printf("In start_x_time().\n");
           
       }
        
        
    }
    void start_Y_timing() 
    {   
                 OS::TISRW ISRW;
       if(enable_Y_rising_flag == true)
       {
           Y_timer.start();
           enable_Y_falling_flag = true;

       }
        
        
    }

    void set_X_time() {
        if(enable_X_falling_flag == true)
        {
             OS::TISRW ISRW;
            X_timer.stop();
            X_time = X_timer.read_us();
            X_timer.reset();
            //                       led3 = !led3;
                                   //printf("In set_x_time().\n");

            
        }
    }
    
    
    void set_Y_time() {
        if(enable_Y_falling_flag == true)
        {
             OS::TISRW ISRW;
            Y_timer.stop();
            Y_time = Y_timer.read_us();
           Y_timer.reset();
              //                   led4 = !led4;

            
        }
    }

    float get_X_time() 
    {
       return X_time;
    }
    
    float get_Y_time() 
    {
       return Y_time;
    }

   
private:
    Timer X_timer;
    Timer Y_timer;
    float X_time; //time in us
    float Y_time;
    InterruptIn X_int;
    InterruptIn Y_int;
    //DigitalIn X_input;
    //DigitalIn Y_input;
    bool enable_X_rising_flag;
    bool enable_X_falling_flag;
    bool enable_Y_rising_flag;
    bool enable_Y_falling_flag;
};








extern BusOut leds;

char ACC_Return_chars[100] = "";


//typedef OS::process<OS::pr2, 1400> Accelo_proc;
template<> OS_PROCESS void Accelo_proc::Exec() //Output stream handling process
{
   
    accelerometer ACC;
     
     byte M = 0;
     for(;;)
     { 
     if(ACCELEROMETER_MESSAGE.wait(70)) //length of time to wait also determines how rapidly to return accelerometer data
       {    leds = 0x2;
            M = ACCELEROMETER_MESSAGE; //read the message that was destined for this process
            ACCELEROMETER_MESSAGE.reset();
       
           if(M == 0) //then return x and y data once
           {
                sprintf(ACC_Return_chars, "ACC_X:%f\nACC_Y:%f\n", ACC.get_X_time(), ACC.get_Y_time()); // ready return string
                //if(!Ser_out_Mutex.IsLocked())
                {
                    //Ser_out_Mutex.Lock();
                    //if(TX_Channel.get_free_size() > strlen(Return_chars)+1)
                        TX_channel.write(ACC_Return_chars, strlen(ACC_Return_chars)+1); //output the data!
                    //Ser_out_Mutex.Unlock();
                }    
                
                
                
           }
       }
       if(M == 1) //ticker
       {
             
              {
                //TCritSect cs;
                sprintf(ACC_Return_chars, "ACC_X:%f\nACC_Y:%f\n", ACC.get_X_time(), ACC.get_Y_time()); // ready return string //"ACC_X:%f\nACC_Y:%f\n"
               }
                //if(!Ser_out_Mutex.IsLocked())
                {
                    //Ser_out_Mutex.Lock();
                    //if(TX_Channel.get_free_size() > strlen(Return_chars)+1)
                         TX_channel.write(ACC_Return_chars, strlen(ACC_Return_chars)+1); //output the data!
                    //Ser_out_Mutex.Unlock();
                }
              //TX_flag.Signal();
            
       }   

            leds = 0x2;
        
       
     }
}

 
 #endif

  



