#pragma once
#ifndef PING_RANGEFINDER_H
#define PING_RANGEFINDER_H

#include <processes.h>
#include <Mutexes.h>
#include <channels.h>
#define PINGPIN p22


//DigitalOut led3(LED3); //these LEDs are used to indicate when an interrupt occurs.
//DigitalOut led4(LED4);
//byte count = 0;

class rangefinder {
public:
    rangefinder()
            :Pinterrupt(PINGPIN), PingPin(PINGPIN)
     {
            //led3 = ~(led4 = 0);
            
            time = 0;
            enable_flag = false;
            set_interrupts();
            PingPin.mode(PullDown);
            //Pinterrupt.mode(PullDown);
    //        Pinterrupt.mode(PullUp);       
            PingPin.output(); //set pingpin as output
            PingPin = 0;
    }

    void ping() {
        T.reset(); //reset the timer to 0
        set_interrupts();
        enable_flag = false;
        PingPin.output(); //set as output
        PingPin = 0; //output initiation sequence of 0 1 0 to the rangefinder
        wait_us(2);
        PingPin = 1;
        wait_us(5);
        PingPin = 0;
        wait_us(1);
        //printf("now waiting for input.\n");
        PingPin.input(); //set as input
        wait_us(10);
        //set_interrupts();
        enable_flag = true;
        wait_ms(25); //more than required for maximum distance measurement
        
        
        
        //T.start(); //begin timing the length of time for an interrupt to occur
    }
    void set_interrupts()
    {
         Pinterrupt.fall(this, &rangefinder::set_time);
         Pinterrupt.rise(this, &rangefinder::start_timing);
    }
    void disable_interrupts()
    {
         Pinterrupt.fall(NULL);
         Pinterrupt.rise(NULL);
    
    } 
    void start_timing() {  OS::TISRW ISRW;
       if(enable_flag == true)
       {
           T.start();
           //led3 = !led3;
           //count++;       
       }
        
        //printf("start_timing called.\n");
    }

    void set_time() { OS::TISRW ISRW;
        if(enable_flag == true)
        {
            T.stop();
            //led4 = !led4;
            //disable_interrupts();
            //enable_flag = false;
            //printf("set_time being called...\n");
            time = T.read_us();
            //count++;
        }
                //printf("value stored in time %f: \n", time);
        
        //PingPin.output();
        //PingPin = 0;
        //printf("PING:%f\n",get_time());

    }
   


    float get_time() {
       //disable_interrupts();
        return time/2.0;
        
    }

   
private:
    Timer T;
    float time; //time in us
    InterruptIn Pinterrupt;
    DigitalInOut PingPin;
    bool enable_flag;
    //Ticker TICKER;// send_ticker;
    

};










extern BusOut leds;

template<> OS_PROCESS void PING_PROC::Exec() //Output stream handling process
{
    byte M = 0;
    rangefinder PING;
 

char PIN_Return_chars[100]; //defined in accelerometer.h
     
     for(;;)
     {
       if(PING_MESSAGE.wait(80)) //length of time to wait also determines how rapidly to ticker ping
       {    leds = 0x2;
            M = PING_MESSAGE; //read the message that was destined for this process
            PING_MESSAGE.reset();
       
           if(M == 0) //then ping! command was sent
           {
                {
                    //OS::TISRW ISRW; //this is a critical section as timing is involved
                    //this will not work though as it disables interrupts. 
                    PING.ping();
                }
                
                {   
                    //TCritSect cs;
                    sprintf(PIN_Return_chars, "PING:%f\n", PING.get_time()); //
                 }
                 //Ser_out_Mutex.Lock();
                //if(TX_Channel.get_free_size() > strlen(Return_chars)+1)
                    TX_channel.write(PIN_Return_chars, strlen(PIN_Return_chars)+1); //output the ping result
                //Ser_out_Mutex.Unlock();
                
                
           }
       }
       if(M == 1) //ticker ping
       {
            {
                //OS::TISRW ISRW; //this is a critical section as timing is involved
                PING.ping();
            }
            //Sleep(2);
             {
                //TCritSect cs;
                sprintf(PIN_Return_chars, "PING:%f\n", PING.get_time()); //"PING:%f\n"
              }
              //Ser_out_Mutex.Lock();
              //if(TX_Channel.get_free_size() > strlen(Return_chars)+1)
               TX_channel.write(PIN_Return_chars, strlen(PIN_Return_chars)+1); //output the result
              //Ser_out_Mutex.Unlock();
             //TX_flag.Signal();
            
       }
       
              //PING_MESSAGE.reset();
            
        leds = 0x2;
       
     }
}

 
 #endif

  //void enable_ticker() {
    //    TICKER.attach_us(this, &rangefinder::ping, TX_RATE); //call ping() every 40 ms
        //send_ticker.attach_us(this, &rangefinder::send_data, TX_RATE); //send the data out every 40 ms
    //}
    //void disable_ticker() {
        //printf("ticker should now be detached.\n");
    //    TICKER.detach();
        //send_ticker.detach();
    //}
 




