#ifndef LPS331AP_h
#define LPS331AP_h

#include "mbed.h"

class lps331
{
    SPI& spi;
    DigitalOut ncs;
  public:
  
    lps331(SPI& _spi, PinName _ncs);
    void select();
    void deselect();
    bool initialize(int setType=0);
    
    int ready(uint8_t sensor);
    //float read_pressure();
    uint32_t read_pressure();
    uint16_t read_temperature();
    float get_Pressure_mbar();
    float get_Temp_C();
    float get_Temp_F();
  private:
    PinName _CS_pin;
    PinName _SO_pin;
    PinName _SCK_pin;
    uint8_t readRegister(uint8_t address);
    void writeRegister(uint8_t address, uint8_t value);
    int _units;
    float _error;
};

#endif
