/* GPSINT.cpp
 * jbradshaw (20141101)
 * GPS functions are work of Tyler Weavers mbed gps library page 
 * (http://mbed.org/users/tylerjw/code/GPS/file/39d75e44b214/GPS.cpp)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
/* This GPSINT library class retrieves, parses, and updates variables using
  a serial receive interrupt.  The library was written using the Trimble
  Copernicus II moduls bus should work on any NMEA 4800 baud output device.
  The relatively slow 4800 baud allows for plenty of processing time during
  byte receptions in the interrupt.  Using the mbed LPC 100MHz unit, it takes
  about 340us to process, and parse the 2 default GPGGA and GPZTG strings.*/

#include "mbed.h"

#ifndef GPSINT_H
#define GPSINT_H

#define PI (3.14159265359)
#define GPSBUFSIZE  256       // GPS buffer size

/**
 * GPSINT Class.
 */
 
class GPSINT{
public:
    /**
     * Constructor.
     * @param gps - Serial port pins attached to the gps
     */ 
    GPSINT(PinName tx, PinName rx);
    int nmea_validate(char *nmeastr);               //runs the checksum calculation on the GPS NMEA string
    void parseGPSString(char *GPSstrParse);         //uses scanf to parse NMEA string into variables
    void GPSSerialRecvInterrupt(void);              //fills temprpary buffer for processing
    float nmea_to_dec(float deg_coord, char nsew);  //convert nmea format to decimal format
    float calc_course_to(float pointLat, float pontLong);
    double calc_dist_to_mi(float pointLat, float pontLong);
    double calc_dist_to_ft(float pointLat, float pontLong);
    double calc_dist_to_km(float pointLat, float pontLong);
    double calc_dist_to_m(float pointLat, float pontLong);
        
    // GPSINT variables
    char GPSbuf[GPSBUFSIZE];     // Receive buffer. 
    char Temp_GPSbuf[GPSBUFSIZE];// Receive buffer. 
    char GPSidx;               // Read by background, written by Int Handler.
    int GPSstate;              //set when successful GPS string is received
    
    // calculated values
    float dec_longitude;
    float dec_latitude;
    float altitude_ft;
    
    // GGA - Global Positioning System Fixed Data
    float nmea_longitude;
    float nmea_latitude;    
    float utc_time;
    char ns, ew;
    int lock;
    char status;
    int satelites;
    float hdop;
    float msl_altitude;
    char msl_units;
    
    // RMC - Recommended Minimmum Specific GNS Data
    char rmc_status;
    float speed_k;
    float course_d;
    int date;
    
    // GLL
    char gll_status;
    
    // VTG - Course over ground, ground speed
    float course_t; // ground speed true
    char course_t_unit;
    float course_m; // magnetic
    char course_m_unit;
    char speed_k_unit;
    float speed_km; // speek km/hr
    char speed_km_unit;
private:
    Serial _gps;
};

#endif /* GPSINT_H */