#include "mbed.h"
#include "uLCD_4D_Picaso.h"
#include "Adafruit_FONA.h"
#include "rtos.h"
#include <string>
#include <vector>

#define FONA_RST p12
#define FONA_TX p13
#define FONA_RX p14
#define FONA_RI p11

using namespace std;
Serial pc(USBTX, USBRX);
Adafruit_FONA fona(FONA_TX, FONA_RX, FONA_RST, FONA_RI);

Mutex mut;
uLCD_4D_Picaso lcd(p28, p27, p30);

vector <string> T_names;
vector<string>::iterator name;



char names[] = "Jesse\r\nGeorge\r\n";

char phone[] = "7067664360\r\n4045189567\r\n";     

int main() {
    //set up strings
    name = T_names.begin();
    name[1] = "Jesse";
    name[2] = "George";
    name[3] = "Cole";
    name[4] = "Brandon";
    
    lcd.setbaudWait(Picaso::BAUD_600000);
    lcd.touch_Set(0);
    lcd.txt_Opacity(Picaso::OPAQUE);
    
    //Set up header
    
    lcd.txt_MoveCursor(0, 6);
    lcd.txt_Attributes(Picaso::BOLD);
    lcd.txt_FGcolour(Picaso::RED);
    lcd.putStr("mbed Roomate Tracker");
    lcd.txt_MoveCursor(2, 0);
    lcd.txt_FGcolour(Picaso::CYAN);
    lcd.putStr("Who's home?");
    
    //print names
    
    lcd.txt_MoveCursor(4, 0);
    lcd.txt_Attributes(Picaso::UNDERLINED);
    lcd.putStr(names);
    
    //Set up touch boxes
    lcd.gfx_RectangleFilled(150, 250, 230, 310, Picaso::WHITE);
    lcd.gfx_RectangleFilled(0, 250, 80, 310, Picaso::WHITE);
    lcd.txt_MoveCursor(23, 3);
    lcd.txt_FGcolour(Picaso::WHITE);
    lcd.txt_Attributes(Picaso::UNDERLINED);
    lcd.putStr("HOME");
    lcd.txt_MoveCursor(23,22);
    lcd.putStr("AWAY");
    
    int status = 0;
    int x = 0;
    int y = 0;
    while (1) {
        status = lcd.touch_Get(0);
        if (status) {
            x = lcd.touch_Get(1);
            y = lcd.touch_Get(2);
                if (status == 1 && x <= 80 && y >= 250) {
                    pc.printf("Text roomates home: I'm home\r\n");
                } else if (status == 1 && x >= 150 && y >= 250) {
                    pc.printf("Text roommates away: I'm home\r\n");
                }
        }
    }
}