#include "mbed.h"
#include "MMA8451Q.h"
#include "M2XStreamClient.h"
#include "include_me.h"


#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

using namespace mts;

const char key[] = "";  // enter your m2x user account master key
const char feed[] = ""; // enter your blueprint feed id
const char* names[] = { "x", "y", "z" };  // user will need to create these Streams manually in the Dev Portal
int counts[] = { 1, 1, 1 };



// set to 1 for cellular shield board
// set to 0 for wifi shield board
#define CELL_SHIELD 1

// ssid and phrase for wifi
std::string ssid = "belkin54g";
std::string phrase = "hackathon";
Wifi::SecurityType security_type = Wifi::WPA;

int main()
{
#if CELL_SHIELD
    MTSSerialFlowControl* serial = new MTSSerialFlowControl(PTD3, PTD2, PTA12, PTC8);
    serial->baud(115200);
    Transport::setTransport(Transport::CELLULAR);
    Cellular* cell = Cellular::getInstance();
    cell->init(serial, PTA4, PTC9); //DCD and DTR pins for KL46Z

    int max_tries = 5;
    int i;
    std::string apn = "m2m.com.attz";

    i = 0;
    while (i++ < max_tries) {
        if (cell->getRegistration() == Cellular::REGISTERED) {
            printf("registered with tower\n\r");
            break;
        } else if (i >= max_tries) {
            printf("failed to register with tower\n\r");
        } else {
            wait(3);
        }
    }

    printf("signal strength: %d\n\r", cell->getSignalStrength());

    i = 0;
    printf("setting APN to %s\n\r", apn.c_str());
    while (i++ < max_tries) {
        if (cell->setApn(apn) == SUCCESS) {
            printf("successfully set APN\n\r");
            break;
        } else if (i >= max_tries) {
            printf("failed to set APN\n\r");
        } else {
            wait(1);
        }
    }

    i = 0;
    printf("bringing up PPP link\n\r");
    while (i++ < max_tries) {
        if (cell->connect()) {
            printf("PPP link is up\n\r");
            break;
        } else if (i >= max_tries) {
            printf("failed to bring PPP link up\n\r");
        } else {
            wait(1);
        }
    }
#else
    for (int i = 6; i >= 0; i = i - 2) {
        wait(2);
        printf("Waiting %d seconds...\n\r", i);
    }
    MTSSerial* serial = new MTSSerial(PTD3, PTD2, 256, 256);
    serial->baud(9600);
    Transport::setTransport(Transport::WIFI);
    Wifi* wifi = Wifi::getInstance();
    printf("Init: %s\n\r", wifi->init(serial) ? "SUCCESS" : "FAILURE");
    printf("Set Network: %s\n\r", getCodeNames(wifi->setNetwork(ssid, security_type, phrase)).c_str());
    printf("Set DHCP: %s\n\r", getCodeNames(wifi->setDeviceIP("DHCP")).c_str());
    printf("Signal Strnegth (dBm): %d\n\r", wifi->getSignalStrength());
    printf("Is Connected: %s\n\r", wifi->isConnected() ? "True" : "False");
    printf("Connect: %s\n\r", wifi->connect() ? "Success" : "Failure");
    printf("Is Connected: %s\n\r", wifi->isConnected() ? "True" : "False");
#endif

    /* send some data */
    Client client;
    M2XStreamClient m2xClient(&client, key);
    int ret;
    int streamNum = 3;
    
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    
    printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        float x, y, z;
        x = rled = 1.0 - abs(acc.getAccX());
        y = gled = 1.0 - abs(acc.getAccY());
        z = bled = 1.0 - abs(acc.getAccZ());
        printf("Sending X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
        double values[] = { x, y, z };
        ret = m2xClient.postMultiple(feed, streamNum, names, counts, NULL, values);
        printf("send() returned %d\r\n", ret);
        wait(5);
    }
    
   
}