#ifndef KICKER_CPP
#define KICKER_CPP
#include "Kicker.h"
#include <mbed.h>
#include "config.h"

DigitalOut * selenoid;
DigitalOut * charge;

Kicker::Kicker()
{
    selenoid = new DigitalOut(PORT_SELENOID);
    charge = new DigitalOut(PORT_CHARGE);
    selenoid->write(0);
    charge->write(1);
}

void Kicker::kicker(float kick_speed)
{
    if(kick_speed != 0) {
        charge->write(0);
        wait_ms(200);
        selenoid->write(1);
        wait_ms(kick_speed);
        selenoid->write(0);
        wait_ms(100);
        charge->write(1);
    }
}

#endif