#ifndef MOTOR_CPP
#define MOTOR_CPP
#include "Motor.h"
#include <mbed.h>
#include "config.h"

I2C * motor;

Motor::Motor()
{
    motor = new I2C(SDA_MOTOR,SCL_MOTOR);
}

void Motor::transmit_i2cmotor(float flpwm,float frpwm,float blpwm,float brpwm)
{
    msg_float[0].data = flpwm;
    msg_float[1].data = frpwm;
    msg_float[2].data = blpwm;
    msg_float[3].data = brpwm;
    motor->write(ADDRES_FLPWM,msg_float[0].m_char,sizeof(msg_float[0].data) + 1);
    motor->write(ADDRES_FRPWM,msg_float[0].m_char,sizeof(msg_float[1].data) + 1);
}

void Motor::read_i2cmotor(){
    RPM[0].data = 0;
    RPM[1].data = 0;
    RPM[2].data = 0;
    RPM[3].data = 0;
    motor->read(ADDRES_FLPWM,RPM[0].m_char,sizeof(RPM[0].data) + 1);
}


#endif