#include "mbed.h"
#include "uLCD_4DGL.h"
#include <string>
#define PURPLE 0x800080
#define ORANGE 0xFFA500
#include "deck.h"
#include <mpr121.h>
#include "PinDetect.h"
uLCD_4DGL uLCD(p28, p27, p30);
PinDetect pb1(p8);
PinDetect pb2(p11);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
// Setup the i2c bus on pins 9 and 10
I2C i2c(p9, p10);
// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);
//InterruptIn interrupt(p26);
Deck gameDeck;
Card playerHand[10];
Card dealerHand[10];
int playerCount=2;
int dealerCount=2;
bool isPlayer=true;
int playerPoints;
int dealerPoints;
int money = 1000;
int bet=100;
int sumHand(Card[]);

void printPoints(int points)
{
    if(points>21) {
        uLCD.printf("Pts=bust");
    } else {
        uLCD.printf("Pts=%d",points);
    }
}
void initialDeal()
{
    playerCount=2;
    dealerCount=2;
    playerHand[0]= gameDeck.cards[0];
    dealerHand[0]=gameDeck.cards[1];
    playerHand[1] = gameDeck.cards[2];
    dealerHand[1] = gameDeck.cards[3];
    uLCD.locate(1,8);
    uLCD.printf("%s%s",playerHand[0].convertRank(),playerHand[0].convertSuit());
    uLCD.locate(4,8);
    uLCD.printf("%s%s",playerHand[1].convertRank(),playerHand[1].convertSuit());
    uLCD.locate(1,3);
    uLCD.printf("%s%s",dealerHand[0].convertRank(),dealerHand[1].convertSuit());

    uLCD.locate(6,10);
    playerPoints = sumHand(playerHand);
    printPoints(playerPoints);
}


void hit()
{
    if(isPlayer) {
        playerHand[playerCount]=gameDeck.cards[playerCount+dealerCount];
        playerCount++;
        uLCD.locate((playerCount-1)*3+1,8);
        uLCD.printf("%s%s",playerHand[playerCount-1].convertRank(),playerHand[playerCount-1].convertSuit());
        uLCD.locate(6,10);
        playerPoints = sumHand(playerHand);
        printPoints(playerPoints);
        wait(1);
    } else {
        dealerHand[dealerCount] = gameDeck.cards[playerCount+dealerCount];
        dealerCount++;
        uLCD.locate((dealerCount-1)*3+1,3);
        uLCD.printf("%s%s",dealerHand[dealerCount-1].convertRank(),dealerHand[dealerCount-1].convertSuit());
        uLCD.locate(6,6.5);
        dealerPoints = sumHand(dealerHand);
        printPoints(dealerPoints);
        wait(1);
    }
}

void getBet()
{
    uLCD.cls();
    uLCD.printf("How much will you bet?\n(10-500)");
    int len=0;
    int amount=0;
    while(len<3) {
        int key=0;
        int i=0;
        int value=mpr121.read(0x00);
        value +=mpr121.read(0x01)<<8;
        // LED demo mod
        i=0;
        // puts key number out to LEDs for demo
        for (i=0; i<12; i++) {
            if (((value>>i)&0x01)==1) key=i+1;

        }
        if(key != 0 ) {
            if(key>10) {
                break;
            } else {
                len++;
                amount*=10;
                amount+=key-1;
                uLCD.printf("%d",key-1);
                wait(.25);
            }
        }
    }
    bet=max(min(amount,500),10);
    bet = min(bet,money);
    uLCD.printf("\nBet = %d",bet);

}
void setup()
{
    uLCD.color(ORANGE);


    getBet();
    uLCD.cls();
    uLCD.locate(6,0.5);
    uLCD.printf("Dealer");

    uLCD.locate(6,7.5);
    uLCD.printf("Player");

    uLCD.filled_rectangle(0,112,127,148,DGREY);
    gameDeck.shuffleDeck();
    initialDeal();

}

// Callback routine is interrupt activated by a debounced pb1 hit
void pb1_hit_callback (void)
{
    hit();

}

// Callback routine is interrupt activated by a debounced pb2 hit
void pb2_hit_callback (void)
{
    isPlayer=false;

}
void walletSize()
{
    uLCD.cls();
    uLCD.printf("NOTE:\nEnter input on pad followed by        key 10\n\n");
    uLCD.printf("top pushbutton is hit and bottom is stand");
    
    wait(5);
    uLCD.cls();
    uLCD.printf("How much will you start with?\n(1000-10000)");
    int len=0;
    int amount=0;
    while(len<5) {
        int key=0;
        int i=0;
        int value=mpr121.read(0x00);
        value +=mpr121.read(0x01)<<8;
        // LED demo mod
        i=0;
        // puts key number out to LEDs for demo
        for (i=0; i<12; i++) {
            if (((value>>i)&0x01)==1) key=i+1;

        }
        if(key != 0 ) {
            if(key>10) {
                break;
            } else {
                len++;
                amount*=10;
                amount+=key-1;
                uLCD.printf("%d",key-1);
                wait(.25);
            }
        }
    }
    money=max(min(amount,50000),1000);

    uLCD.printf("\nWallet = %d",money);

}
void game();
int main()
{
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.01);
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    //uLCD.color(ORANGE);
    //uLCD.printf("How much money to play with?(minimum bet $10)");
    walletSize();
    game();

}
int sumHand(Card[]);
void result(int);
void dealerTurn();
void game()
{
    while(money>=100) {
        isPlayer = true;
        setup();
        uLCD.locate(0,14);
        uLCD.printf("Cash=%d",money);
        uLCD.locate(10,14);
        uLCD.printf("Bet=%d",bet);
        while(isPlayer) {
            if(sumHand(playerHand)>21) {
                result(2);
            }
        }
        dealerTurn();
    }
    while(1) {
        uLCD.cls();
        uLCD.locate(3,7);
        uLCD.printf("GAME OVER");
        wait(1);
    }
}
void result(int outcome)
{
    uLCD.cls();
    if(outcome == 0) {

        uLCD.locate(6,7);
        uLCD.printf("Player Won ");
        money += bet;
    } else if(outcome == 1) {
        uLCD.locate(6,7);
        uLCD.printf("Game Draw");

    } else if(outcome == 2) {
        uLCD.locate(6,7);
        uLCD.printf("Player Lost ");
        money -=bet;
    }
    wait(1);
    game();
}
void dealerTurn()
{
    isPlayer = false;
    uLCD.locate(4,3);
    uLCD.printf("%s%s",dealerHand[1].convertRank(),dealerHand[1].convertSuit());
    uLCD.locate(6,6.5);
    dealerPoints = sumHand(dealerHand);
    printPoints(dealerPoints);
    wait(1);
    while(dealerPoints<17) {
        hit();
    }
    if(dealerPoints>21) {
        result(0);
    } else if(playerPoints>dealerPoints) {
        result(0);
    } else if(playerPoints<dealerPoints) {
        result(2);
    } else {
        result(1);
    }
}


int sumHand(Card hand[])
{
    int sum=0;
    int aces=0;
    int count= isPlayer? playerCount:dealerCount;
    for(int i=0; i<count; i++) {
        Card card = hand[i];
        if(card._rank==1) {
            sum+=11;
            aces++;
        } else if(card._rank < 11) {
            sum+=card._rank;
        } else {
            sum+=10;
        }
    }
    if(sum>21) {
        if(aces>0) {
            if(isPlayer) {
                while(aces>0 && sum > 21) {
                    sum-=10;
                    aces--;
                }
            } else {
                if(sum>=27) {
                    while(aces>0 && sum > 21) {
                        sum-=10;
                        aces--;
                    }
                }

            }
        }
    }
    return sum;
}